/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.BEPrefixedTypeBuilder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEInteger;
import java.math.BigInteger;

class BEIntegerBuilder
extends BEPrefixedTypeBuilder<BEInteger> {
    private StringBuilder buf = new StringBuilder();

    BEIntegerBuilder() {
    }

    @Override
    protected boolean doAccept(int b) {
        char c = (char)b;
        if (Character.isDigit(c) || this.buf.length() == 0 && c == '-') {
            this.buf.append(c);
            return true;
        }
        throw new IllegalArgumentException("Unexpected token while reading integer (as ASCII char): " + c);
    }

    @Override
    protected boolean acceptEOF() {
        return true;
    }

    @Override
    public BEType getType() {
        return BEType.INTEGER;
    }

    @Override
    protected BEInteger doBuild(byte[] content) {
        return new BEInteger(content, new BigInteger(this.buf.toString()));
    }
}

