/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.BEObjectBuilder;
import bt.bencoding.BEParser;
import bt.bencoding.BEPrefixedTypeBuilder;
import bt.bencoding.BEStringBuilder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

class BEMapBuilder
extends BEPrefixedTypeBuilder<BEMap> {
    private final Map<String, BEObject<?>> map = new HashMap();
    private BEStringBuilder keyBuilder;
    private BEObjectBuilder<? extends BEObject<?>> valueBuilder;
    private Charset keyCharset = Charset.forName("UTF-8");

    BEMapBuilder() {
    }

    @Override
    protected boolean doAccept(int b) {
        if (this.keyBuilder == null) {
            this.keyBuilder = new BEStringBuilder();
        }
        if (this.valueBuilder == null) {
            if (!this.keyBuilder.accept(b)) {
                BEType valueType = BEParser.getTypeForPrefix((char)b);
                this.valueBuilder = BEParser.builderForType(valueType);
                return this.valueBuilder.accept(b);
            }
        } else if (!this.valueBuilder.accept(b)) {
            this.map.put(this.keyBuilder.build().getValue(this.keyCharset), this.valueBuilder.build());
            this.keyBuilder = null;
            this.valueBuilder = null;
            return this.accept(b, false);
        }
        return true;
    }

    @Override
    protected BEMap doBuild(byte[] content) {
        return new BEMap(content, this.map);
    }

    @Override
    protected boolean acceptEOF() {
        return this.keyBuilder == null && this.valueBuilder == null;
    }

    @Override
    public BEType getType() {
        return BEType.MAP;
    }
}

