/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.BEIntegerBuilder;
import bt.bencoding.BEListBuilder;
import bt.bencoding.BEMapBuilder;
import bt.bencoding.BEObjectBuilder;
import bt.bencoding.BEStringBuilder;
import bt.bencoding.BEType;
import bt.bencoding.BtParseException;
import bt.bencoding.Scanner;
import bt.bencoding.model.BEInteger;
import bt.bencoding.model.BEList;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

public class BEParser
implements AutoCloseable {
    static final char EOF = 'e';
    static final char INTEGER_PREFIX = 'i';
    static final char LIST_PREFIX = 'l';
    static final char MAP_PREFIX = 'd';
    private Scanner scanner;
    private final BEType type;
    private Object parsedObject;

    public BEParser(URL url) {
        Objects.requireNonNull(url, "Missing URL");
        try {
            this.scanner = new Scanner(url.openStream());
        }
        catch (IOException e) {
            throw new BtParseException("Failed to open stream for URL: " + url, new byte[0], e);
        }
        this.type = BEParser.getTypeForPrefix((char)this.scanner.peek());
    }

    public BEParser(InputStream in) {
        Objects.requireNonNull(in, "Input stream is null");
        this.scanner = new Scanner(in);
        this.type = BEParser.getTypeForPrefix((char)this.scanner.peek());
    }

    public BEParser(byte[] bs) {
        if (bs == null || bs.length == 0) {
            throw new IllegalArgumentException("Can't parse bytes array: null or empty");
        }
        this.scanner = new Scanner(bs);
        this.type = BEParser.getTypeForPrefix((char)this.scanner.peek());
    }

    public BEType readType() {
        return this.type;
    }

    static char getPrefixForType(BEType type) {
        if (type == null) {
            throw new NullPointerException("Can't get prefix -- type is null");
        }
        switch (type) {
            case INTEGER: {
                return 'i';
            }
            case LIST: {
                return 'l';
            }
            case MAP: {
                return 'd';
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type.name().toLowerCase());
    }

    static BEType getTypeForPrefix(char c) {
        if (Character.isDigit(c)) {
            return BEType.STRING;
        }
        switch (c) {
            case 'i': {
                return BEType.INTEGER;
            }
            case 'l': {
                return BEType.LIST;
            }
            case 'd': {
                return BEType.MAP;
            }
        }
        throw new IllegalStateException("Invalid type prefix: " + c);
    }

    static BEObjectBuilder<? extends BEObject<?>> builderForType(BEType type) {
        switch (type) {
            case STRING: {
                return new BEStringBuilder();
            }
            case INTEGER: {
                return new BEIntegerBuilder();
            }
            case LIST: {
                return new BEListBuilder();
            }
            case MAP: {
                return new BEMapBuilder();
            }
        }
        throw new IllegalStateException("Unknown type: " + type.name().toLowerCase());
    }

    public BEString readString() {
        return (BEString)this.readObject(BEType.STRING, BEStringBuilder.class);
    }

    public BEInteger readInteger() {
        return (BEInteger)this.readObject(BEType.INTEGER, BEIntegerBuilder.class);
    }

    public BEList readList() {
        return (BEList)this.readObject(BEType.LIST, BEListBuilder.class);
    }

    public BEMap readMap() {
        return (BEMap)this.readObject(BEType.MAP, BEMapBuilder.class);
    }

    private <T extends BEObject> T readObject(BEType type, Class<? extends BEObjectBuilder<T>> builderClass) {
        this.assertType(type);
        BEObject result = (BEObject)this.parsedObject;
        if (result == null) {
            try {
                result = this.scanner.readObject(builderClass.newInstance());
                this.parsedObject = result;
            }
            catch (Exception e) {
                throw new BtParseException("Failed to read from encoded data", this.scanner.getScannedContents(), e);
            }
        }
        return (T)result;
    }

    private void assertType(BEType type) {
        if (type == null) {
            throw new NullPointerException("Invalid type -- null");
        }
        if (this.type != type) {
            throw new IllegalStateException("Can't read " + type.name().toLowerCase() + " from: " + this.type.name().toLowerCase());
        }
    }

    @Override
    public void close() {
        if (this.scanner != null) {
            this.scanner.close();
        }
    }
}

