/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.BEObjectBuilder;
import bt.bencoding.BEParser;
import bt.bencoding.BEType;
import bt.bencoding.model.BEObject;
import java.io.ByteArrayOutputStream;

abstract class BEPrefixedTypeBuilder<T extends BEObject>
implements BEObjectBuilder<T> {
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private boolean receivedPrefix;
    private boolean receivedEOF;

    BEPrefixedTypeBuilder() {
    }

    @Override
    public final boolean accept(int b) {
        return this.accept(b, true);
    }

    protected boolean accept(int b, boolean shouldLog) {
        if (this.receivedEOF) {
            return false;
        }
        if (shouldLog) {
            this.buf.write(b);
        }
        if (!this.receivedPrefix) {
            BEType type = this.getType();
            if (b == BEParser.getPrefixForType(type)) {
                this.receivedPrefix = true;
                return true;
            }
            throw new IllegalArgumentException("Invalid prefix for type " + type.name().toLowerCase() + " (as ASCII char): " + (char)b);
        }
        if (b == 101 && this.acceptEOF()) {
            this.receivedEOF = true;
            return true;
        }
        return this.doAccept(b);
    }

    @Override
    public T build() {
        if (!this.receivedPrefix) {
            throw new IllegalStateException("Can't build " + this.getType().name().toLowerCase() + " -- no content");
        }
        if (!this.receivedEOF) {
            throw new IllegalStateException("Can't build " + this.getType().name().toLowerCase() + " -- content was not terminated");
        }
        return this.doBuild(this.buf.toByteArray());
    }

    protected abstract boolean doAccept(int var1);

    protected abstract T doBuild(byte[] var1);

    protected abstract boolean acceptEOF();
}

