/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.BEObjectBuilder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEString;
import java.io.ByteArrayOutputStream;

class BEStringBuilder
implements BEObjectBuilder<BEString> {
    static final char DELIMITER = ':';
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private int length;
    private int bytesAcceptedCount;
    private boolean shouldReadBody;

    BEStringBuilder() {
    }

    @Override
    public boolean accept(int b) {
        char c = (char)b;
        if (this.shouldReadBody) {
            if (this.bytesAcceptedCount + 1 > this.length) {
                return false;
            }
        } else {
            if (this.bytesAcceptedCount == 0 && !Character.isDigit(c)) {
                throw new IllegalArgumentException("Unexpected token while reading string's length (as ASCII char): " + c);
            }
            if (c == ':') {
                this.shouldReadBody = true;
                this.bytesAcceptedCount = 0;
                this.length = Integer.parseInt(this.buf.toString());
                this.buf = new ByteArrayOutputStream(this.length);
                return true;
            }
        }
        this.buf.write(b);
        ++this.bytesAcceptedCount;
        return true;
    }

    @Override
    public BEString build() {
        if (!this.shouldReadBody) {
            throw new IllegalStateException("Can't build string: no content");
        }
        if (this.bytesAcceptedCount < this.length) {
            throw new IllegalStateException("Can't build string: insufficient content");
        }
        return new BEString(this.buf.toByteArray());
    }

    @Override
    public BEType getType() {
        return BEType.STRING;
    }
}

