/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding;

import bt.bencoding.BEObjectBuilder;
import bt.bencoding.model.BEObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class Scanner {
    private final MemoizingPushbackInputStream source;

    Scanner(byte[] bs) {
        this(new ByteArrayInputStream(bs));
    }

    Scanner(InputStream in) {
        this.source = new MemoizingPushbackInputStream(in);
    }

    <T extends BEObject> T readObject(BEObjectBuilder<T> builder) throws Exception {
        int c;
        this.source.resetContents();
        while ((c = this.source.read()) != -1 && builder.accept(c)) {
        }
        return builder.build();
    }

    int peek() {
        return this.source.peek();
    }

    byte[] getScannedContents() {
        return this.source.getContents();
    }

    void close() {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class MemoizingPushbackInputStream
    extends InputStream {
        private PushbackInputStream delegate;
        private ByteArrayOutputStream buf;

        MemoizingPushbackInputStream(InputStream delegate) {
            this.delegate = new PushbackInputStream(delegate);
            this.buf = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int c = this.delegate.read();
            this.buf.write(c);
            return c;
        }

        public int peek() {
            try {
                int c = this.delegate.read();
                this.delegate.unread(c);
                return c;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected I/O exception", e);
            }
        }

        public void resetContents() {
            this.buf = new ByteArrayOutputStream();
        }

        public byte[] getContents() {
            return this.buf.toByteArray();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

