/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.BEEncoder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEObject;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class BEInteger
implements BEObject<BigInteger> {
    private byte[] content;
    private BigInteger value;
    private BEEncoder encoder;

    public BEInteger(byte[] content, BigInteger value) {
        this.content = content;
        this.value = value;
        this.encoder = BEEncoder.encoder();
    }

    @Override
    public BEType getType() {
        return BEType.INTEGER;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.encoder.encode(this, out);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BEInteger)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.value.equals(((BEInteger)obj).getValue());
    }

    public String toString() {
        return this.value.toString(10);
    }
}

