/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.BEEncoder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BEList
implements BEObject<List<? extends BEObject<?>>> {
    private byte[] content;
    private List<? extends BEObject<?>> value;
    private BEEncoder encoder;

    public BEList(byte[] content, List<? extends BEObject<?>> value) {
        this.content = content;
        this.value = Collections.unmodifiableList(value);
        this.encoder = BEEncoder.encoder();
    }

    @Override
    public BEType getType() {
        return BEType.LIST;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public List<? extends BEObject<?>> getValue() {
        return this.value;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.encoder.encode(this, out);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BEList)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.value.equals(((BEList)obj).getValue());
    }

    public String toString() {
        return Arrays.toString(this.value.toArray());
    }
}

