/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.BEEncoder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class BEMap
implements BEObject<Map<String, BEObject<?>>> {
    private byte[] content;
    private Map<String, BEObject<?>> value;
    private BEEncoder encoder;

    public BEMap(byte[] content, Map<String, BEObject<?>> value) {
        this.content = content;
        this.value = Collections.unmodifiableMap(value);
        this.encoder = BEEncoder.encoder();
    }

    @Override
    public BEType getType() {
        return BEType.MAP;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public Map<String, BEObject<?>> getValue() {
        return this.value;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.encoder.encode(this, out);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BEMap)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.value.equals(((BEMap)obj).getValue());
    }

    public String toString() {
        return this.value.toString();
    }
}

