/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.BEEncoder;
import bt.bencoding.BEType;
import bt.bencoding.model.BEObject;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class BEString
implements BEObject<byte[]> {
    private static final Charset defaultCharset = Charset.forName("UTF-8");
    private byte[] content;
    private BEEncoder encoder;
    private volatile String stringValue;
    private final Object lock;

    public BEString(byte[] content) {
        this.content = content;
        this.encoder = BEEncoder.encoder();
        this.lock = new Object();
    }

    @Override
    public BEType getType() {
        return BEType.STRING;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public byte[] getValue() {
        return this.content;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.encoder.encode(this, out);
    }

    public String getValue(Charset charset) {
        return new String(this.content, charset);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BEString)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Arrays.equals(this.content, ((BEString)obj).getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.stringValue == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.stringValue == null) {
                    this.stringValue = new String(this.content, defaultCharset);
                }
            }
        }
        return this.stringValue;
    }
}

