/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEObjectModel;
import bt.bencoding.model.TypesMapping;
import bt.bencoding.model.ValidationResult;
import bt.bencoding.model.rule.Rule;
import java.util.List;

abstract class BaseBEObjectModel
implements BEObjectModel {
    private List<Rule> rules;

    BaseBEObjectModel(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public final ValidationResult validate(Object object) {
        ValidationResult result;
        if (object != null) {
            Class<?> javaType;
            if (object instanceof BEObject) {
                object = ((BEObject)object).getValue();
            }
            if (!(javaType = TypesMapping.getJavaTypeForBEType(this.getType())).isAssignableFrom(object.getClass())) {
                ValidationResult result2 = new ValidationResult();
                result2.addMessage("Wrong type -- expected " + javaType.getName() + ", actual: " + object.getClass().getName());
                return result2;
            }
        }
        return (result = this.validateObject(object)).isSuccess() ? this.afterValidate(result, object) : result;
    }

    private ValidationResult validateObject(Object object) {
        ValidationResult result = new ValidationResult();
        this.rules.stream().filter(rule -> !rule.validate(object)).map(Rule::getDescription).forEach(result::addMessage);
        return result;
    }

    protected abstract ValidationResult afterValidate(ValidationResult var1, Object var2);
}

