/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import java.util.List;
import java.util.Map;

public class ClassUtil {
    public static <T> T read(Map map, Class<T> type, Object key) throws Exception {
        Object value = map.get(key);
        return (T)(value == null ? value : ClassUtil.cast(type, key, value));
    }

    public static <T> T readNotNull(Map map, Class<T> type, Object key) throws Exception {
        Object value = map.get(key);
        if (value == null) {
            throw new Exception("Value is missing for key: " + key);
        }
        return ClassUtil.cast(type, key, value);
    }

    public static <T> T cast(Class<T> type, Object key, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new Exception("Value has invalid type" + (key == null ? "" : " for key: " + key) + " -- expected '" + type.getName() + "', got: " + value.getClass().getName());
        }
        return (T)value;
    }

    public static <T> List<T> castList(Class<T> elementType, List<?> list) throws Exception {
        if (list == null) {
            return null;
        }
        for (Object element : list) {
            if (elementType.isAssignableFrom(element.getClass())) continue;
            throw new Exception("List element has invalid type -- expected '" + elementType.getName() + "', got: " + element.getClass().getName());
        }
        return list;
    }
}

