/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.model.BEIntegerModel;
import bt.bencoding.model.BEListModel;
import bt.bencoding.model.BEMapModel;
import bt.bencoding.model.BEObjectModel;
import bt.bencoding.model.BEObjectModelBuilder;
import bt.bencoding.model.BEStringModel;
import bt.bencoding.model.ClassUtil;
import bt.bencoding.model.rule.ExclusiveRule;
import bt.bencoding.model.rule.RequiredRule;
import bt.bencoding.model.rule.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class JUMModelBuilder
implements BEObjectModelBuilder<Map> {
    private static final String TYPE_KEY = "type";
    private static final String REQUIRED_KEY = "required";
    private static final String EXCLUSIVES_KEY = "exclusives";
    private static final String MAP_ENTRIES_KEY = "entries";
    private static final String MAP_ENTRY_KEY_KEY = "key";
    private static final String LIST_ELEMENTS_KEY = "elements";

    @Override
    public BEObjectModel buildModel(Map map) {
        return this.readObjectModel(map).orElseGet(() -> {
            try {
                String sourceType;
                switch (sourceType = this.readType(map)) {
                    case "dictionary": {
                        return this.buildMap(map);
                    }
                    case "list": {
                        return this.buildList(map);
                    }
                    case "binary": {
                        return new BEStringModel(true, Collections.emptyList());
                    }
                    case "string": {
                        return new BEStringModel(false, Collections.emptyList());
                    }
                    case "integer": {
                        return new BEIntegerModel(Collections.emptyList());
                    }
                }
                throw new IllegalArgumentException("Unsupported BE type: " + sourceType);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to build BE model", e);
            }
        });
    }

    private Optional<BEObjectModel> readObjectModel(Map map) {
        try {
            Object objectModel = ClassUtil.read(map, Object.class, TYPE_KEY);
            if (objectModel == null || !Map.class.isAssignableFrom(objectModel.getClass())) {
                return Optional.empty();
            }
            return Optional.of(this.buildModel((Map)objectModel));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read type", e);
        }
    }

    private String readType(Map map) {
        try {
            return ClassUtil.readNotNull(map, String.class, TYPE_KEY).toLowerCase();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read type", e);
        }
    }

    private BEObjectModel buildMap(Map map) throws Exception {
        List<Map> entries = ClassUtil.castList(Map.class, ClassUtil.readNotNull(map, List.class, MAP_ENTRIES_KEY));
        HashMap<String, BEObjectModel> entriesModel = new HashMap<String, BEObjectModel>(entries.size() + 1);
        for (Map entry : entries) {
            String key = ClassUtil.readNotNull(entry, String.class, MAP_ENTRY_KEY_KEY);
            entriesModel.put(key, this.buildModel(entry));
        }
        return new BEMapModel(entriesModel, this.buildMapValidation(map, entries));
    }

    private List<Rule> buildMapValidation(Map map, List<Map> entries) throws Exception {
        ArrayList rules = new ArrayList(2);
        List<String> required = entries.stream().filter(this::isRequired).map(entry -> {
            try {
                return ClassUtil.readNotNull(entry, String.class, MAP_ENTRY_KEY_KEY);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error", e);
            }
        }).collect(Collectors.toList());
        List exclusives = ClassUtil.cast(List.class, EXCLUSIVES_KEY, map.get(EXCLUSIVES_KEY));
        if (exclusives != null) {
            Collection exclusiveSets = exclusives.stream().map(item -> {
                if (item instanceof String) {
                    return Collections.singleton((String)item);
                }
                try {
                    List<String> strings = ClassUtil.castList(String.class, ClassUtil.cast(List.class, null, item));
                    return new HashSet<String>(strings);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error", e);
                }
            }).collect(Collectors.toList());
            rules.add(new ExclusiveRule(exclusiveSets, required));
        } else {
            rules.add(new RequiredRule(required));
        }
        return rules.isEmpty() ? Collections.emptyList() : rules;
    }

    private boolean isRequired(Map map) {
        try {
            return map.get(REQUIRED_KEY) == null ? true : ClassUtil.cast(Boolean.class, REQUIRED_KEY, map.get(REQUIRED_KEY));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to check if object is required", e);
        }
    }

    private BEListModel buildList(Map map) throws Exception {
        Map elements = ClassUtil.readNotNull(map, Map.class, LIST_ELEMENTS_KEY);
        BEObjectModel elementModel = this.buildModel(elements);
        return new BEListModel(elementModel, Collections.emptyList());
    }

    @Override
    public Class<Map> getSourceType() {
        return Map.class;
    }
}

