/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model;

import bt.bencoding.model.BEObjectModel;
import bt.bencoding.model.BEObjectModelBuilderFactory;
import bt.bencoding.model.BEObjectModelLoader;
import bt.bencoding.model.DefaultModelBuilderFactory;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlBEObjectModelLoader
implements BEObjectModelLoader {
    private static final String MODEL_DEFINITION_KEY = "model";
    private BEObjectModelBuilderFactory modelBuilderFactory;
    private Yaml yaml = new Yaml();

    public YamlBEObjectModelLoader() {
        this.modelBuilderFactory = new DefaultModelBuilderFactory();
    }

    @Override
    public BEObjectModel load(InputStream source) {
        if (source == null) {
            throw new NullPointerException("Missing source -- null");
        }
        return this.fromYaml(this.yaml.load(source));
    }

    private BEObjectModel fromYaml(Object yamlObject) {
        if (!List.class.isAssignableFrom(yamlObject.getClass())) {
            throw new IllegalArgumentException("Invalid model -- root document must be a list");
        }
        List entries = (List)yamlObject;
        for (Object entry : entries) {
            if (!(entry instanceof Map) || !((Map)entry).containsKey(MODEL_DEFINITION_KEY)) continue;
            return this.buildObjectModel(((Map)entry).get(MODEL_DEFINITION_KEY));
        }
        throw new IllegalArgumentException("Invalid model -- missing model definition");
    }

    private BEObjectModel buildObjectModel(Object modelDefinition) {
        return this.modelBuilderFactory.getOrCreateBuilder(modelDefinition.getClass()).apply(modelDefinition);
    }
}

