/*
 * Decompiled with CFR 0.152.
 */
package bt.bencoding.model.rule;

import bt.bencoding.model.ClassUtil;
import bt.bencoding.model.rule.RequiredRule;
import bt.bencoding.model.rule.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExclusiveRule
implements Rule {
    boolean shouldCheckRequired;
    private RequiredRule exclusiveRequired;
    private RequiredRule otherRequired;
    private Collection<Set<String>> exclusives;

    public ExclusiveRule(Collection<Set<String>> exclusives, List<String> required) {
        this.shouldCheckRequired = true;
        List allExclusives = exclusives.stream().flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<String> otherRequiredKeys = new ArrayList<String>();
        otherRequiredKeys.addAll(required);
        otherRequiredKeys.removeAll(allExclusives);
        this.otherRequired = new RequiredRule(otherRequiredKeys);
        ArrayList<String> exclusiveRequiredKeys = new ArrayList<String>();
        exclusiveRequiredKeys.addAll(required);
        exclusiveRequiredKeys.removeAll(otherRequiredKeys);
        this.exclusiveRequired = new RequiredRule(exclusiveRequiredKeys);
        this.exclusives = exclusives;
    }

    public ExclusiveRule(Collection<Set<String>> exclusives) {
        this.exclusives = exclusives;
    }

    @Override
    public boolean validate(Object object) {
        try {
            Map map = ClassUtil.cast(Map.class, null, object);
            long count = this.exclusives.stream().map(exclusive -> {
                ArrayList found = new ArrayList(exclusive.size() + 1);
                exclusive.forEach(key -> {
                    Object obj = map.get(key);
                    if (obj != null) {
                        found.add(obj);
                    }
                });
                return found;
            }).filter(found -> !found.isEmpty()).count();
            if (count > 1L) {
                return false;
            }
            if (this.shouldCheckRequired) {
                if (count == 0L) {
                    return this.exclusiveRequired.validate(object) && this.otherRequired.validate(object);
                }
                return this.otherRequired.validate(object);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected validation exception", e);
        }
    }

    @Override
    public String getDescription() {
        String description = "properties are mutually exclusive: " + Arrays.toString(this.exclusives.toArray());
        if (this.exclusiveRequired != null) {
            description = description + "; " + this.exclusiveRequired.toString();
        }
        if (this.otherRequired != null) {
            description = description + "; " + this.otherRequired.toString();
        }
        return description;
    }

    public String toString() {
        return this.getDescription();
    }
}

