/*
 * Copyright (c) 2016—2017 Andrei Tomashpolskiy and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package bt.metainfo;

import java.util.List;

/**
 * Torrent file descriptor.
 * Contains size and a path relative to the root of the containing torrent.
 *
 * @since 1.0
 */
public interface TorrentFile {

    /**
     * @return Size of this file, in bytes.
     * @since 1.0
     */
    long getSize();

    /**
     * @return A list of UTF-8 encoded strings corresponding to subdirectory names,
     *         the last of which is the actual file name (thus it always contains at least one element).
     * @since 1.0
     */
    List<String> getPathElements();
}
