/*
 * Copyright (c) 2016—2017 Andrei Tomashpolskiy and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package bt.processor;

import bt.processor.listener.ProcessingEvent;

/**
 * @param <C> Type of processing context
 * @since 1.3
 */
public interface ProcessingStage<C extends ProcessingContext> {

    /**
     * @return Type of event, that should be triggered after this stage has completed.
     * @since 1.5
     */
    ProcessingEvent after();

    /**
     * @param context Processing context
     * @return Next stage
     * @since 1.3
     */
    ProcessingStage<C> execute(C context);
}
