/*
 * Decompiled with CFR 0.152.
 */
package bt;

import bt.DefaultClient;
import bt.LazyClient;
import bt.processor.ProcessingContext;
import bt.processor.Processor;
import bt.processor.ProcessorFactory;
import bt.processor.listener.ListenerSource;
import bt.runtime.BtClient;
import bt.runtime.BtRuntime;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class BaseClientBuilder<B extends BaseClientBuilder> {
    private BtRuntime runtime;
    private boolean shouldInitEagerly;

    protected BaseClientBuilder() {
    }

    protected B runtime(BtRuntime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "Missing runtime");
        return (B)this;
    }

    public B initEagerly() {
        this.shouldInitEagerly = true;
        return (B)this;
    }

    public BtClient build() {
        Objects.requireNonNull(this.runtime, "Missing runtime");
        Supplier<BtClient> clientSupplier = () -> this.buildClient(this.runtime, this.buildProcessingContext(this.runtime));
        return this.shouldInitEagerly ? clientSupplier.get() : new LazyClient(clientSupplier);
    }

    protected abstract ProcessingContext buildProcessingContext(BtRuntime var1);

    private <C extends ProcessingContext> BtClient buildClient(BtRuntime runtime, C context) {
        Class<?> contextType = context.getClass();
        ListenerSource listenerSource = new ListenerSource(contextType);
        this.collectStageListeners(listenerSource);
        return new DefaultClient(runtime, this.processor(runtime, contextType), context, listenerSource);
    }

    protected abstract <C extends ProcessingContext> void collectStageListeners(ListenerSource<C> var1);

    private <C extends ProcessingContext> Processor<C> processor(BtRuntime runtime, Class<C> contextType) {
        Processor<C> processor = runtime.service(ProcessorFactory.class).processor(contextType);
        if (processor == null) {
            throw new IllegalStateException("No processors found for context type: " + contextType.getName());
        }
        return processor;
    }
}

