/*
 * Decompiled with CFR 0.152.
 */
package bt;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class BufferingMap<K, E> {
    private final ConcurrentMap<K, Collection<E>> m = new ConcurrentHashMap<K, Collection<E>>();
    private final Supplier<? extends Collection<E>> valueSupplier;

    public BufferingMap(Supplier<? extends Collection<E>> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public synchronized boolean containsKey(K key) {
        Collection values = (Collection)this.m.get(key);
        return values != null && values.size() > 0;
    }

    public synchronized void add(K key, E element) {
        Collection values = this.m.computeIfAbsent(key, it -> this.valueSupplier.get());
        values.add(element);
    }

    public synchronized Collection<E> removeCopy(K key) {
        Collection<Object> copy;
        Collection values = (Collection)this.m.get(key);
        if (values == null) {
            copy = Collections.emptySet();
        } else {
            copy = this.valueSupplier.get();
            if (values.size() > 0) {
                copy.addAll(values);
                values.clear();
            }
        }
        return copy;
    }
}

