/*
 * Decompiled with CFR 0.152.
 */
package bt;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class CountingThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final boolean daemon;
    private final AtomicLong threadIndex;

    public static CountingThreadFactory factory(String prefix) {
        return new CountingThreadFactory(prefix, false);
    }

    public static CountingThreadFactory daemonFactory(String prefix) {
        return new CountingThreadFactory(prefix, true);
    }

    public CountingThreadFactory(String prefix, boolean daemon) {
        this.prefix = Objects.requireNonNull(prefix);
        this.daemon = daemon;
        this.threadIndex = new AtomicLong(0L);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.newThreadName());
        if (this.daemon) {
            t.setDaemon(true);
        }
        return t;
    }

    private String newThreadName() {
        return String.format("%s-%d", this.prefix, this.threadIndex.getAndIncrement());
    }
}

