/*
 * Decompiled with CFR 0.152.
 */
package bt;

import bt.BtException;
import bt.processor.ProcessingContext;
import bt.processor.Processor;
import bt.processor.listener.ListenerSource;
import bt.runtime.BtClient;
import bt.runtime.BtRuntime;
import bt.torrent.TorrentSessionState;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

class DefaultClient<C extends ProcessingContext>
implements BtClient {
    private BtRuntime runtime;
    private Processor<C> processor;
    private ListenerSource<C> listenerSource;
    private C context;
    private volatile Optional<CompletableFuture<?>> futureOptional;
    private volatile Optional<Consumer<TorrentSessionState>> listenerOptional;
    private volatile ScheduledExecutorService listenerExecutor;

    public DefaultClient(BtRuntime runtime, Processor<C> processor, C context, ListenerSource<C> listenerSource) {
        this.runtime = runtime;
        this.processor = processor;
        this.context = context;
        this.listenerSource = listenerSource;
        this.futureOptional = Optional.empty();
        this.listenerOptional = Optional.empty();
    }

    @Override
    public synchronized CompletableFuture<?> startAsync(Consumer<TorrentSessionState> listener, long period) {
        if (this.futureOptional.isPresent()) {
            throw new BtException("Can't start -- already running");
        }
        this.listenerExecutor = Executors.newSingleThreadScheduledExecutor();
        this.listenerOptional = Optional.of(listener);
        this.listenerExecutor.scheduleAtFixedRate(this::notifyListener, period, period, TimeUnit.MILLISECONDS);
        return this.doStartAsync();
    }

    private void notifyListener() {
        this.listenerOptional.ifPresent(listener -> this.context.getState().ifPresent(listener::accept));
    }

    private void shutdownListener() {
        this.listenerExecutor.shutdownNow();
    }

    @Override
    public synchronized CompletableFuture<?> startAsync() {
        if (this.futureOptional.isPresent()) {
            throw new BtException("Can't start -- already running");
        }
        return this.doStartAsync();
    }

    private CompletableFuture<?> doStartAsync() {
        this.ensureRuntimeStarted();
        this.attachToRuntime();
        CompletableFuture<?> future = this.processor.process(this.context, this.listenerSource);
        ((CompletableFuture)((CompletableFuture)future.whenComplete((r, t) -> this.notifyListener())).whenComplete((r, t) -> this.shutdownListener())).whenComplete((r, t) -> this.stop());
        this.futureOptional = Optional.of(future);
        return future;
    }

    @Override
    public synchronized void stop() {
        if (this.futureOptional.isPresent()) {
            CompletableFuture<?> f = this.futureOptional.get();
            this.futureOptional = Optional.empty();
            f.complete(null);
            this.detachFromRuntime();
        }
    }

    private void ensureRuntimeStarted() {
        if (!this.runtime.isRunning()) {
            this.runtime.startup();
        }
    }

    private void attachToRuntime() {
        this.runtime.attachClient(this);
    }

    private void detachFromRuntime() {
        this.runtime.detachClient(this);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.futureOptional.isPresent();
    }
}

