/*
 * Decompiled with CFR 0.152.
 */
package bt;

import bt.runtime.BtClient;
import bt.torrent.TorrentSessionState;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

class LazyClient
implements BtClient {
    private Supplier<BtClient> clientSupplier;
    private volatile BtClient delegate;

    public LazyClient(Supplier<BtClient> clientSupplier) {
        this.clientSupplier = clientSupplier;
    }

    private synchronized void initClient() {
        if (this.delegate == null) {
            this.delegate = this.clientSupplier.get();
        }
    }

    @Override
    public CompletableFuture<?> startAsync() {
        if (this.delegate == null) {
            this.initClient();
        }
        return this.delegate.startAsync();
    }

    @Override
    public CompletableFuture<?> startAsync(Consumer<TorrentSessionState> listener, long period) {
        if (this.delegate == null) {
            this.initClient();
        }
        return this.delegate.startAsync(listener, period);
    }

    @Override
    public void stop() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.stop();
    }

    @Override
    public boolean isStarted() {
        return this.delegate != null && this.delegate.isStarted();
    }
}

