/*
 * Decompiled with CFR 0.152.
 */
package bt;

import bt.BaseClientBuilder;
import bt.data.Storage;
import bt.magnet.MagnetUri;
import bt.magnet.MagnetUriParser;
import bt.metainfo.IMetadataService;
import bt.metainfo.Torrent;
import bt.processor.ProcessingContext;
import bt.processor.ProcessingStage;
import bt.processor.listener.ListenerSource;
import bt.processor.listener.ProcessingEvent;
import bt.processor.magnet.MagnetContext;
import bt.processor.torrent.TorrentContext;
import bt.runtime.BtRuntime;
import bt.torrent.PieceSelectionStrategy;
import bt.torrent.selector.PieceSelector;
import bt.torrent.selector.RarestFirstSelector;
import bt.torrent.selector.SelectorAdapter;
import bt.torrent.selector.SequentialSelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TorrentClientBuilder<B extends TorrentClientBuilder>
extends BaseClientBuilder<B> {
    private Storage storage;
    private URL torrentUrl;
    private Supplier<Torrent> torrentSupplier;
    private MagnetUri magnetUri;
    private PieceSelector pieceSelector = RarestFirstSelector.randomizedRarest();
    private List<Consumer<Torrent>> torrentConsumers;
    private boolean stopWhenDownloaded;

    protected TorrentClientBuilder() {
    }

    public B storage(Storage storage) {
        this.storage = Objects.requireNonNull(storage, "Missing data storage");
        return (B)this;
    }

    public B torrent(URL torrentUrl) {
        Objects.requireNonNull(torrentUrl, "Missing torrent file URL");
        this.torrentUrl = torrentUrl;
        this.torrentSupplier = null;
        this.magnetUri = null;
        return (B)this;
    }

    public B torrent(Supplier<Torrent> torrentSupplier) {
        this.torrentUrl = null;
        this.torrentSupplier = Objects.requireNonNull(torrentSupplier, "Missing torrent supplier");
        this.magnetUri = null;
        return (B)this;
    }

    public B magnet(String magnetUri) {
        this.torrentUrl = null;
        this.torrentSupplier = null;
        this.magnetUri = MagnetUriParser.lenientParser().parse(magnetUri);
        return (B)this;
    }

    public B magnet(MagnetUri magnetUri) {
        this.torrentUrl = null;
        this.torrentSupplier = null;
        this.magnetUri = Objects.requireNonNull(magnetUri, "Missing magnet URI");
        return (B)this;
    }

    public B selector(PieceSelectionStrategy pieceSelectionStrategy) {
        Objects.requireNonNull(pieceSelectionStrategy, "Missing piece selection strategy");
        this.pieceSelector = new SelectorAdapter(pieceSelectionStrategy);
        return (B)this;
    }

    public B selector(PieceSelector pieceSelector) {
        this.pieceSelector = Objects.requireNonNull(pieceSelector, "Missing piece selector");
        return (B)this;
    }

    public B sequentialSelector() {
        return this.selector(SequentialSelector.sequential());
    }

    public B rarestSelector() {
        return this.selector(RarestFirstSelector.rarest());
    }

    public B randomizedRarestSelector() {
        return this.selector(RarestFirstSelector.randomizedRarest());
    }

    public B stopWhenDownloaded() {
        this.stopWhenDownloaded = true;
        return (B)this;
    }

    public B afterTorrentFetched(Consumer<Torrent> torrentConsumer) {
        if (this.torrentConsumers == null) {
            this.torrentConsumers = new ArrayList<Consumer<Torrent>>();
        }
        this.torrentConsumers.add(torrentConsumer);
        return (B)this;
    }

    @Override
    protected ProcessingContext buildProcessingContext(BtRuntime runtime) {
        TorrentContext context;
        Objects.requireNonNull(this.storage, "Missing data storage");
        if (this.torrentUrl != null) {
            context = new TorrentContext(this.pieceSelector, this.storage, () -> this.fetchTorrentFromUrl(runtime, this.torrentUrl));
        } else if (this.torrentSupplier != null) {
            context = new TorrentContext(this.pieceSelector, this.storage, this.torrentSupplier);
        } else if (this.magnetUri != null) {
            context = new MagnetContext(this.magnetUri, this.pieceSelector, this.storage);
        } else {
            throw new IllegalStateException("Missing torrent supplier, torrent URL or magnet URI");
        }
        return context;
    }

    @Override
    protected <C extends ProcessingContext> void collectStageListeners(ListenerSource<C> listenerSource) {
        if (this.torrentConsumers != null) {
            BiFunction<ProcessingContext, ProcessingStage, ProcessingStage> listener = (context, next) -> {
                context.getTorrent().ifPresent(torrent -> {
                    for (Consumer<Torrent> torrentConsumer : this.torrentConsumers) {
                        torrentConsumer.accept((Torrent)torrent);
                    }
                });
                return next;
            };
            listenerSource.addListener(ProcessingEvent.TORRENT_FETCHED, listener);
        }
        if (this.stopWhenDownloaded) {
            listenerSource.addListener(ProcessingEvent.DOWNLOAD_COMPLETE, (context, next) -> null);
        }
    }

    private Torrent fetchTorrentFromUrl(BtRuntime runtime, URL metainfoUrl) {
        return runtime.service(IMetadataService.class).fromUrl(metainfoUrl);
    }
}

