/*
 * Decompiled with CFR 0.152.
 */
package bt.data;

import bt.BtException;
import bt.data.ChunkDescriptor;
import bt.protocol.Protocols;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public class Bitfield {
    private final byte[] value;
    private final int piecesTotal;
    private volatile int piecesComplete;
    private final Optional<List<ChunkDescriptor>> chunks;
    private final ReentrantLock lock;

    public Bitfield(List<ChunkDescriptor> chunks) {
        this.chunks = Optional.of(chunks);
        this.piecesTotal = chunks.size();
        this.value = new byte[Bitfield.getBitmaskLength(this.piecesTotal)];
        this.piecesComplete = 0;
        this.lock = new ReentrantLock();
    }

    public Bitfield(int piecesTotal) {
        this(new byte[Bitfield.getBitmaskLength(piecesTotal)], piecesTotal);
    }

    public Bitfield(byte[] value, int piecesTotal) {
        int expectedBitmaskLength = Bitfield.getBitmaskLength(piecesTotal);
        if (value.length != expectedBitmaskLength) {
            throw new IllegalArgumentException("Invalid bitfield: total (" + piecesTotal + "), bitmask length (" + value.length + "). Expected bitmask length: " + expectedBitmaskLength);
        }
        this.value = value;
        this.chunks = Optional.empty();
        this.piecesTotal = piecesTotal;
        this.piecesComplete = Bitfield.getPiecesComplete(value);
        this.lock = new ReentrantLock();
    }

    private static int getBitmaskLength(int piecesTotal) {
        return (int)Math.ceil((double)piecesTotal / 8.0);
    }

    private static int getPiecesComplete(byte[] value) {
        return BitSet.valueOf(value).cardinality();
    }

    public byte[] getBitmask() {
        this.lock.lock();
        try {
            byte[] byArray = Arrays.copyOf(this.value, this.value.length);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPiecesTotal() {
        return this.piecesTotal;
    }

    public int getPiecesComplete() {
        return this.piecesComplete;
    }

    public int getPiecesRemaining() {
        return this.piecesTotal - this.piecesComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PieceStatus getPieceStatus(int pieceIndex) {
        ChunkDescriptor chunk;
        boolean verified;
        this.validatePieceIndex(pieceIndex);
        this.lock.lock();
        try {
            verified = Protocols.getBit(this.value, pieceIndex) == 1;
        }
        finally {
            this.lock.unlock();
        }
        PieceStatus status = verified ? PieceStatus.COMPLETE_VERIFIED : (this.chunks.isPresent() ? ((chunk = this.chunks.get().get(pieceIndex)).isComplete() ? PieceStatus.COMPLETE : PieceStatus.INCOMPLETE) : PieceStatus.INCOMPLETE);
        return status;
    }

    public boolean isComplete(int pieceIndex) {
        PieceStatus pieceStatus = this.getPieceStatus(pieceIndex);
        return pieceStatus == PieceStatus.COMPLETE || pieceStatus == PieceStatus.COMPLETE_VERIFIED;
    }

    public boolean isVerified(int pieceIndex) {
        PieceStatus pieceStatus = this.getPieceStatus(pieceIndex);
        return pieceStatus == PieceStatus.COMPLETE_VERIFIED;
    }

    public void markVerified(int pieceIndex) {
        this.assertChunkComplete(pieceIndex);
        this.lock.lock();
        try {
            Protocols.setBit(this.value, pieceIndex);
            this.piecesComplete = Bitfield.getPiecesComplete(this.value);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertChunkComplete(int pieceIndex) {
        this.validatePieceIndex(pieceIndex);
        if (this.chunks.isPresent() && !this.chunks.get().get(pieceIndex).isComplete()) {
            throw new IllegalStateException("Chunk is not complete: " + pieceIndex);
        }
    }

    private void validatePieceIndex(Integer pieceIndex) {
        if (pieceIndex < 0 || pieceIndex >= this.piecesTotal) {
            throw new BtException("Illegal piece index: " + pieceIndex);
        }
    }

    public static enum PieceStatus {
        INCOMPLETE,
        COMPLETE,
        COMPLETE_VERIFIED;

    }
}

