/*
 * Decompiled with CFR 0.152.
 */
package bt.data;

import bt.data.BlockSet;
import bt.data.ChunkDescriptor;
import bt.data.DataRange;

class DefaultChunkDescriptor
implements ChunkDescriptor {
    private final DataRange data;
    private final BlockSet blockSet;
    private final byte[] checksum;

    public DefaultChunkDescriptor(DataRange data, BlockSet blockSet, byte[] checksum) {
        this.data = data;
        this.blockSet = blockSet;
        this.checksum = checksum;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public DataRange getData() {
        return this.data;
    }

    @Override
    public int blockCount() {
        return this.blockSet.blockCount();
    }

    @Override
    public long length() {
        return this.blockSet.length();
    }

    @Override
    public long blockSize() {
        return this.blockSet.blockSize();
    }

    @Override
    public long lastBlockSize() {
        return this.blockSet.lastBlockSize();
    }

    @Override
    public boolean isPresent(int blockIndex) {
        return this.blockSet.isPresent(blockIndex);
    }

    @Override
    public boolean isComplete() {
        return this.blockSet.isComplete();
    }

    @Override
    public boolean isEmpty() {
        return this.blockSet.isEmpty();
    }
}

