/*
 * Decompiled with CFR 0.152.
 */
package bt.data;

import bt.BtException;
import bt.data.Bitfield;
import bt.data.ChunkDescriptor;
import bt.data.ChunkVerifier;
import bt.data.digest.Digester;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChunkVerifier
implements ChunkVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultChunkVerifier.class);
    private Digester digester;
    private int numOfHashingThreads;

    public DefaultChunkVerifier(Digester digester, int numOfHashingThreads) {
        this.digester = digester;
        this.numOfHashingThreads = numOfHashingThreads;
    }

    @Override
    public boolean verify(List<ChunkDescriptor> chunks, Bitfield bitfield) {
        if (chunks.size() != bitfield.getPiecesTotal()) {
            throw new IllegalArgumentException("Bitfield has different size than the list of chunks. Bitfield size: " + bitfield.getPiecesTotal() + ", number of chunks: " + chunks.size());
        }
        ChunkDescriptor[] arr = chunks.toArray(new ChunkDescriptor[chunks.size()]);
        if (this.numOfHashingThreads > 1) {
            this.collectParallel(arr, bitfield);
        } else {
            this.createWorker(arr, 0, arr.length, bitfield).run();
        }
        System.gc();
        return bitfield.getPiecesRemaining() == 0;
    }

    @Override
    public boolean verify(ChunkDescriptor chunk) {
        byte[] expected = chunk.getChecksum();
        byte[] actual = this.digester.digest(chunk.getData());
        return Arrays.equals(expected, actual);
    }

    private List<ChunkDescriptor> collectParallel(ChunkDescriptor[] chunks, Bitfield bitfield) {
        int i;
        int n = this.numOfHashingThreads;
        ExecutorService workers = Executors.newFixedThreadPool(n);
        ArrayList futures = new ArrayList();
        int batchSize = chunks.length / n;
        int limit = 0;
        while ((i = limit) < chunks.length) {
            limit = futures.size() == n - 1 ? chunks.length : i + batchSize;
            futures.add(workers.submit(this.createWorker(chunks, i, Math.min(chunks.length, limit), bitfield)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Verifying torrent data with {} workers", (Object)futures.size());
        }
        ConcurrentHashMap.KeySetView errors = ConcurrentHashMap.newKeySet();
        futures.forEach(f -> {
            try {
                f.get();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error during verification of torrent data", (Throwable)e);
                errors.add(e);
            }
        });
        workers.shutdown();
        while (!workers.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new BtException("Unexpectedly interrupted");
            }
        }
        if (!errors.isEmpty()) {
            throw new BtException("Failed to verify torrent data:" + errors.stream().map(this::errorToString).reduce(String::concat).get());
        }
        return Arrays.asList(chunks);
    }

    private Runnable createWorker(ChunkDescriptor[] chunks, int from, int to, Bitfield bitfield) {
        return () -> {
            for (int i = from; i < to; ++i) {
                boolean verified;
                int[] emptyUnits = new int[]{0};
                chunks[i].getData().visitUnits((u, off, lim) -> {
                    if (u.size() == 0L) {
                        emptyUnits[0] = emptyUnits[0] + 1;
                    }
                    return true;
                });
                if (emptyUnits[0] != 0 || !(verified = this.verify(chunks[i]))) continue;
                bitfield.markVerified(i);
            }
        };
    }

    private String errorToString(Throwable e) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        e.printStackTrace(out);
        buf.append(bos.toString());
        return buf.toString();
    }
}

