/*
 * Decompiled with CFR 0.152.
 */
package bt.data;

import bt.BtException;
import bt.data.Bitfield;
import bt.data.BlockSet;
import bt.data.ChunkDescriptor;
import bt.data.ChunkVerifier;
import bt.data.DataDescriptor;
import bt.data.DataRange;
import bt.data.DefaultChunkDescriptor;
import bt.data.ReadWriteDataRange;
import bt.data.Storage;
import bt.data.StorageUnit;
import bt.data.range.BlockRange;
import bt.data.range.Ranges;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDataDescriptor
implements DataDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDataDescriptor.class);
    private Storage storage;
    private Torrent torrent;
    private List<ChunkDescriptor> chunkDescriptors;
    private Bitfield bitfield;
    private List<StorageUnit> storageUnits;
    private ChunkVerifier verifier;

    public DefaultDataDescriptor(Storage storage, Torrent torrent, ChunkVerifier verifier, int transferBlockSize) {
        this.storage = storage;
        this.torrent = torrent;
        this.verifier = verifier;
        this.init(transferBlockSize);
    }

    private void init(long transferBlockSize) {
        List<TorrentFile> files = this.torrent.getFiles();
        long totalSize = this.torrent.getSize();
        long chunkSize = this.torrent.getChunkSize();
        if (transferBlockSize > chunkSize) {
            transferBlockSize = chunkSize;
        }
        int chunksTotal = (int)Math.ceil(totalSize / chunkSize);
        ArrayList<ChunkDescriptor> chunks = new ArrayList<ChunkDescriptor>(chunksTotal + 1);
        Iterator<byte[]> chunkHashes = this.torrent.getChunkHashes().iterator();
        this.storageUnits = files.stream().map(f -> this.storage.getUnit(this.torrent, (TorrentFile)f)).collect(Collectors.toList());
        ArrayList<StorageUnit> nonEmptyStorageUnits = new ArrayList<StorageUnit>();
        for (StorageUnit unit : this.storageUnits) {
            if (unit.capacity() > 0L) {
                nonEmptyStorageUnits.add(unit);
                continue;
            }
            try {
                unit.writeBlock(new byte[0], 0L);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create empty storage unit: " + unit, (Throwable)e);
            }
        }
        if (nonEmptyStorageUnits.size() > 0) {
            long limitInLastUnit = ((StorageUnit)nonEmptyStorageUnits.get(nonEmptyStorageUnits.size() - 1)).capacity();
            ReadWriteDataRange data = new ReadWriteDataRange(nonEmptyStorageUnits, 0L, limitInLastUnit);
            for (long remaining = totalSize; remaining > 0L; remaining -= chunkSize) {
                long off = (long)chunks.size() * chunkSize;
                long lim = Math.min(chunkSize, remaining);
                DataRange subrange = data.getSubrange(off, lim);
                if (!chunkHashes.hasNext()) {
                    throw new BtException("Wrong number of chunk hashes in the torrent: too few");
                }
                chunks.add(this.buildChunkDescriptor(subrange, transferBlockSize, chunkHashes.next()));
            }
        }
        if (chunkHashes.hasNext()) {
            throw new BtException("Wrong number of chunk hashes in the torrent: too many");
        }
        this.bitfield = this.buildBitfield(chunks);
        this.chunkDescriptors = chunks;
    }

    private ChunkDescriptor buildChunkDescriptor(DataRange data, long blockSize, byte[] checksum) {
        BlockRange<DataRange> blockData = Ranges.blockRange(data, blockSize);
        DataRange synchronizedData = Ranges.synchronizedDataRange(blockData);
        BlockSet synchronizedBlockSet = Ranges.synchronizedBlockSet(blockData.getBlockSet());
        return new DefaultChunkDescriptor(synchronizedData, synchronizedBlockSet, checksum);
    }

    private Bitfield buildBitfield(List<ChunkDescriptor> chunks) {
        Bitfield bitfield = new Bitfield(chunks.size());
        this.verifier.verify(chunks, bitfield);
        return bitfield;
    }

    @Override
    public List<ChunkDescriptor> getChunkDescriptors() {
        return this.chunkDescriptors;
    }

    @Override
    public Bitfield getBitfield() {
        return this.bitfield;
    }

    @Override
    public void close() {
        this.storageUnits.forEach(unit -> {
            try {
                unit.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close storage unit: " + unit);
            }
        });
    }

    public String toString() {
        return this.getClass().getName() + " <" + this.torrent.getName() + ">";
    }
}

