/*
 * Decompiled with CFR 0.152.
 */
package bt.data;

import bt.data.DataRange;
import bt.data.DataRangeVisitor;
import bt.data.StorageUnit;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ReadWriteDataRange
implements DataRange {
    private final List<StorageUnit> units;
    private final int firstUnit;
    private final int lastUnit;
    private final long offsetInFirstUnit;
    private final long limitInLastUnit;
    private final long length;
    private long[] fileOffsets;

    public ReadWriteDataRange(List<StorageUnit> units, long offsetInFirstUnit, long limitInLastUnit) {
        this(units, 0, offsetInFirstUnit, units.size() - 1, limitInLastUnit);
    }

    private ReadWriteDataRange(List<StorageUnit> units, int firstUnit, long offsetInFirstUnit, int lastUnit, long limitInLastUnit) {
        if (units.isEmpty()) {
            throw new IllegalArgumentException("Empty list of units");
        }
        if (firstUnit < 0 || firstUnit > units.size() - 1) {
            throw new IllegalArgumentException("Invalid first unit index: " + firstUnit + ", expected 0.." + (units.size() - 1));
        }
        if (lastUnit < 0 || lastUnit > units.size() - 1) {
            throw new IllegalArgumentException("Invalid last unit index: " + lastUnit + ", expected 0.." + (units.size() - 1));
        }
        if (firstUnit > lastUnit) {
            throw new IllegalArgumentException("First unit index is greater than last unit index: " + firstUnit + " > " + lastUnit);
        }
        if (offsetInFirstUnit < 0L || offsetInFirstUnit > units.get(firstUnit).capacity() - 1L) {
            throw new IllegalArgumentException("Invalid offset in first unit: " + offsetInFirstUnit + ", expected 0.." + (units.get(firstUnit).capacity() - 1L));
        }
        if (limitInLastUnit <= 0L || limitInLastUnit > units.get(lastUnit).capacity()) {
            throw new IllegalArgumentException("Invalid limit in last unit: " + limitInLastUnit + ", expected 1.." + units.get(lastUnit).capacity());
        }
        if (firstUnit == lastUnit && offsetInFirstUnit >= limitInLastUnit) {
            throw new IllegalArgumentException("Offset is greater than limit in a single-unit range: " + offsetInFirstUnit + " >= " + limitInLastUnit);
        }
        this.units = units;
        this.fileOffsets = ReadWriteDataRange.calculateOffsets(units, offsetInFirstUnit);
        this.firstUnit = firstUnit;
        this.lastUnit = lastUnit;
        this.offsetInFirstUnit = offsetInFirstUnit;
        this.limitInLastUnit = limitInLastUnit;
        this.length = ReadWriteDataRange.calculateLength(units, offsetInFirstUnit, limitInLastUnit);
    }

    private static long calculateLength(List<StorageUnit> units, long offsetInFirstUnit, long limitInLastUnit) {
        long size;
        if (units.size() == 1) {
            size = limitInLastUnit - offsetInFirstUnit;
        } else {
            size = units.get(0).capacity() - offsetInFirstUnit;
            for (int i = 1; i < units.size() - 1; ++i) {
                size += units.get(i).capacity();
            }
            size += limitInLastUnit;
        }
        return size;
    }

    private static long[] calculateOffsets(List<StorageUnit> units, long offsetInFirstUnit) {
        long[] fileOffsets = new long[units.size()];
        fileOffsets[0] = 0L;
        if (units.size() > 1) {
            fileOffsets[1] = units.get(0).capacity() - offsetInFirstUnit;
        }
        for (int i = 2; i < units.size(); ++i) {
            fileOffsets[i] = fileOffsets[i - 1] + units.get(i - 1).capacity();
        }
        return fileOffsets;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public ReadWriteDataRange getSubrange(long offset, long length) {
        if (length == 0L) {
            throw new IllegalArgumentException("Requested empty subrange, expected length of 1.." + this.length());
        }
        if (offset < 0L || length < 0L) {
            throw new IllegalArgumentException("Illegal arguments: offset (" + offset + "), length (" + length + ")");
        }
        if (offset >= this.length()) {
            throw new IllegalArgumentException("Offset is too large: " + offset + ", expected 0.." + (this.length() - 1L));
        }
        if (offset == 0L && length == this.length()) {
            return this;
        }
        int firstRequestedFileIndex = -1;
        for (int i = 0; i < this.units.size(); ++i) {
            if (offset < this.fileOffsets[i]) {
                firstRequestedFileIndex = i - 1;
                break;
            }
            if (i != this.units.size() - 1) continue;
            firstRequestedFileIndex = i;
        }
        long offsetInFirstRequestedFile = offset - this.fileOffsets[firstRequestedFileIndex];
        if (firstRequestedFileIndex == 0) {
            offsetInFirstRequestedFile += this.offsetInFirstUnit;
        }
        int lastRequestedFileIndex = firstRequestedFileIndex;
        long remaining = length;
        do {
            if (firstRequestedFileIndex == lastRequestedFileIndex) {
                remaining -= this.units.get(lastRequestedFileIndex).capacity() - offsetInFirstRequestedFile;
                continue;
            }
            remaining -= this.units.get(lastRequestedFileIndex).capacity();
        } while (remaining > 0L && ++lastRequestedFileIndex < this.units.size());
        if (lastRequestedFileIndex >= this.units.size()) {
            throw new IllegalArgumentException("Insufficient data (offset: " + offset + ", requested length: " + length + ")");
        }
        long limitInLastRequestedFile = this.units.get(lastRequestedFileIndex).capacity() + remaining;
        if (lastRequestedFileIndex == this.units.size() - 1 && limitInLastRequestedFile > this.limitInLastUnit) {
            throw new IllegalArgumentException("Insufficient data (offset: " + offset + ", requested length: " + length + ")");
        }
        ArrayList<StorageUnit> _units = new ArrayList<StorageUnit>();
        int len = lastRequestedFileIndex - firstRequestedFileIndex;
        _units.addAll(Arrays.asList(Arrays.copyOfRange(this.units.toArray(new StorageUnit[len]), firstRequestedFileIndex, lastRequestedFileIndex + 1)));
        return new ReadWriteDataRange(_units, offsetInFirstRequestedFile, limitInLastRequestedFile);
    }

    @Override
    public DataRange getSubrange(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Illegal arguments: offset (" + offset + ")");
        }
        return offset == 0L ? this : this.getSubrange(offset, this.length() - offset);
    }

    @Override
    public byte[] getBytes() {
        if (this.length() > Integer.MAX_VALUE) {
            throw new IllegalStateException("Range is too big: " + this.length());
        }
        byte[] block = new byte[(int)this.length()];
        final ByteBuffer buffer = ByteBuffer.wrap(block);
        this.visitUnits(new DataRangeVisitor(){
            int offsetInBlock = 0;

            @Override
            public boolean visitUnit(StorageUnit unit, long off, long lim) {
                long len = lim - off;
                if (len > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Too much data requested");
                }
                if ((long)this.offsetInBlock + len > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Integer overflow while constructing block");
                }
                buffer.limit(this.offsetInBlock + (int)len);
                buffer.position(this.offsetInBlock);
                unit.readBlock(buffer, off);
                this.offsetInBlock = (int)((long)this.offsetInBlock + len);
                return true;
            }
        });
        return block;
    }

    @Override
    public void putBytes(final byte[] block) {
        if (block.length == 0) {
            return;
        }
        if ((long)block.length > this.length()) {
            throw new IllegalArgumentException(String.format("Data does not fit in this range (expected max %d bytes, actual: %d)", this.length(), block.length));
        }
        final ByteBuffer buffer = ByteBuffer.wrap(block).asReadOnlyBuffer();
        this.visitUnits(new DataRangeVisitor(){
            int offsetInBlock = 0;
            int limitInBlock;

            @Override
            public boolean visitUnit(StorageUnit unit, long off, long lim) {
                long fileSize = lim - off;
                if (fileSize > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Unexpected file size -- insufficient data in block");
                }
                this.limitInBlock = Math.min(buffer.capacity(), this.offsetInBlock + (int)fileSize);
                buffer.limit(this.limitInBlock);
                buffer.position(this.offsetInBlock);
                unit.writeBlock(buffer, off);
                this.offsetInBlock = this.limitInBlock;
                return this.offsetInBlock < block.length - 1;
            }
        });
    }

    @Override
    public void visitUnits(DataRangeVisitor visitor) {
        for (int i = this.firstUnit; i <= this.lastUnit; ++i) {
            StorageUnit file = this.units.get(i);
            long off = i == this.firstUnit ? this.offsetInFirstUnit : 0L;
            long lim = i == this.lastUnit ? this.limitInLastUnit : file.capacity();
            visitor.visitUnit(file, off, lim);
        }
    }
}

