/*
 * Decompiled with CFR 0.152.
 */
package bt.data.digest;

import bt.BtException;
import bt.data.DataRange;
import bt.data.digest.Digester;
import bt.data.range.Range;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JavaSecurityDigester
implements Digester {
    private final String algorithm;
    private final int step;

    public JavaSecurityDigester(String algorithm, int step) {
        try {
            MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: " + algorithm, e);
        }
        this.algorithm = algorithm;
        this.step = step;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] digest(DataRange data) {
        MessageDigest digest = this.createDigest();
        data.visitUnits((unit, off, lim) -> {
            long remaining = lim - off;
            if (remaining > Integer.MAX_VALUE) {
                throw new BtException("Too much data -- can't read to buffer");
            }
            do {
                digest.update(unit.readBlock(off, Math.min(this.step, (int)remaining)));
                off += (long)this.step;
            } while ((remaining -= (long)this.step) > 0L);
            return true;
        });
        return digest.digest();
    }

    @Override
    public byte[] digest(Range<?> data) {
        MessageDigest digest = this.createDigest();
        long len = data.length();
        if (len <= (long)this.step) {
            digest.update(data.getBytes());
        } else {
            for (long i = 0L; i < len; i += (long)this.step) {
                digest.update(data.getSubrange(i, Math.min(len - i, (long)this.step)).getBytes());
            }
        }
        return digest.digest();
    }

    private MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BtException("Unexpected error", e);
        }
    }
}

