/*
 * Decompiled with CFR 0.152.
 */
package bt.data.file;

import bt.data.Storage;
import bt.data.StorageUnit;
import bt.data.file.FileSystemStorageUnit;
import bt.data.file.PathNormalizer;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentFile;
import java.io.File;
import java.nio.file.Path;

public class FileSystemStorage
implements Storage {
    private final Path rootDirectory;
    private final PathNormalizer pathNormalizer;

    @Deprecated
    public FileSystemStorage(File rootDirectory) {
        this(rootDirectory.toPath());
    }

    public FileSystemStorage(Path rootDirectory) {
        this.rootDirectory = rootDirectory;
        this.pathNormalizer = new PathNormalizer();
    }

    @Override
    public StorageUnit getUnit(Torrent torrent, TorrentFile torrentFile) {
        Path torrentDirectory;
        if (torrent.getFiles().size() == 1) {
            torrentDirectory = this.rootDirectory;
        } else {
            String normalizedName = this.pathNormalizer.normalize(torrent.getName());
            torrentDirectory = this.rootDirectory.resolve(normalizedName);
        }
        String normalizedPath = this.pathNormalizer.normalize(torrentFile.getPathElements());
        return new FileSystemStorageUnit(torrentDirectory, normalizedPath, torrentFile.getSize());
    }
}

