/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.BlockSet;
import bt.data.range.DelegatingRange;
import bt.data.range.MutableBlockSet;
import bt.data.range.Range;

public class BlockRange<T extends Range<T>>
implements Range<BlockRange<T>>,
DelegatingRange<T> {
    private final Range<T> delegate;
    private final long offset;
    private final MutableBlockSet blockSet;

    BlockRange(Range<T> delegate, long blockSize) {
        this(delegate, 0L, new MutableBlockSet(delegate.length(), blockSize));
    }

    private BlockRange(Range<T> delegate, long offset, MutableBlockSet blockSet) {
        this.delegate = delegate;
        this.offset = offset;
        this.blockSet = blockSet;
    }

    public BlockSet getBlockSet() {
        return this.blockSet;
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public BlockRange<T> getSubrange(long offset, long length) {
        return new BlockRange<T>(this.delegate.getSubrange(offset, length), offset, this.blockSet);
    }

    @Override
    public BlockRange<T> getSubrange(long offset) {
        return new BlockRange<T>(this.delegate.getSubrange(offset), offset, this.blockSet);
    }

    @Override
    public byte[] getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public void putBytes(byte[] block) {
        this.delegate.putBytes(block);
        this.blockSet.markAvailable(this.offset, block.length);
    }

    @Override
    public T getDelegate() {
        return (T)this.delegate;
    }
}

