/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.range.Range;
import java.nio.ByteBuffer;

public class ByteRange
implements Range<ByteRange> {
    private final ByteBuffer buffer;

    public ByteRange(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteRange(byte[] bytes, int offset, int limit) {
        int available = bytes.length;
        if (available == 0) {
            throw new IllegalArgumentException("Empty byte array");
        }
        ByteRange.checkOffsetAndLimit(offset, limit, available);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.limit(limit);
        buf.position(offset);
        this.buffer = buf;
    }

    public ByteRange(ByteBuffer buffer) {
        if (buffer.remaining() == 0) {
            throw new IllegalArgumentException("Empty buffer");
        }
        this.buffer = buffer;
    }

    @Override
    public long length() {
        return this.buffer.remaining();
    }

    public ByteRange getSubrange(long offset, long length) {
        long available = this.length();
        if (offset == 0L && length == available) {
            return this;
        }
        ByteRange.checkOffset(offset, available);
        ByteRange.checkLength(offset, length, available);
        ByteBuffer copy = this.buffer.duplicate();
        copy.position((int)offset);
        copy.limit((int)(offset + length));
        return new ByteRange(copy);
    }

    public ByteRange getSubrange(long offset) {
        if (offset == 0L) {
            return this;
        }
        ByteRange.checkOffset(offset, this.length());
        ByteBuffer copy = this.buffer.duplicate();
        copy.position((int)offset);
        return new ByteRange(copy);
    }

    @Override
    public byte[] getBytes() {
        int position = this.buffer.position();
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        this.buffer.position(position);
        return bytes;
    }

    @Override
    public void putBytes(byte[] block) {
        if (block.length == 0) {
            return;
        }
        if ((long)block.length > this.length()) {
            throw new IllegalArgumentException(String.format("Data does not fit in this range (expected max %d bytes, actual: %d)", this.length(), block.length));
        }
        int position = this.buffer.position();
        this.buffer.put(block);
        this.buffer.position(position);
    }

    private static void checkOffsetAndLimit(long offset, int limit, int available) {
        ByteRange.checkOffset(offset, available);
        ByteRange.checkLimit(limit, available);
        if (offset >= (long)limit) {
            throw new IllegalArgumentException("Offset is larger than or equal to limit (offset: " + offset + ", limit: " + limit + ")");
        }
    }

    private static void checkOffset(long offset, long available) {
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset is too large: " + offset);
        }
        if (offset < 0L || offset > available - 1L) {
            throw new IllegalArgumentException("Invalid offset: " + offset + ", expected 0.." + (available - 1L));
        }
    }

    private static void checkLimit(long limit, long available) {
        if (limit > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Limit is too large: " + limit);
        }
        if (limit < 0L || limit > available) {
            throw new IllegalArgumentException("Invalid limit: " + limit + ", expected 1.." + available);
        }
    }

    private static void checkLength(long offset, long length, long available) {
        if (length < 0L) {
            throw new IllegalArgumentException("Requested negative length: " + length);
        }
        long maxlen = Math.min(available - offset, Integer.MAX_VALUE - offset);
        if (length == 0L) {
            throw new IllegalArgumentException("Requested empty subrange, expected length of 1.." + maxlen);
        }
        if (length > maxlen) {
            throw new IllegalArgumentException("Insufficient data: requested " + length + " bytes, expected 1.." + maxlen);
        }
    }
}

