/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.DataRange;
import bt.data.DataRangeVisitor;
import bt.data.range.DelegatingRange;
import bt.data.range.Range;
import java.util.function.Function;

class DelegatingDataRange<T extends Range<T>>
implements DataRange,
DelegatingRange<T> {
    private Range<T> delegate;
    private Function<Range<T>, DataRange> converter;

    static <E extends Range<E>> DelegatingDataRange range(E delegate, Function<E, DataRange> converter) {
        return new DelegatingDataRange(delegate, r -> (DataRange)converter.apply(r));
    }

    private DelegatingDataRange(Range<T> delegate, Function<Range<T>, DataRange> converter) {
        this.delegate = delegate;
        this.converter = converter;
    }

    @Override
    public void visitUnits(DataRangeVisitor visitor) {
        this.converter.apply(this.delegate).visitUnits(visitor);
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public DataRange getSubrange(long offset, long length) {
        return new DelegatingDataRange<T>(this.delegate.getSubrange(offset, length), this.converter);
    }

    @Override
    public DataRange getSubrange(long offset) {
        return new DelegatingDataRange<T>(this.delegate.getSubrange(offset), this.converter);
    }

    @Override
    public byte[] getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public void putBytes(byte[] block) {
        this.delegate.putBytes(block);
    }

    @Override
    public T getDelegate() {
        return (T)this.delegate;
    }
}

