/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.BlockSet;
import java.util.BitSet;

class MutableBlockSet
implements BlockSet {
    private final long length;
    private final long blockSize;
    private final int blockCount;
    private final long lastBlockSize;
    private final long lastBlockOffset;
    private final BitSet bitmask;

    MutableBlockSet(long length, long blockSize) {
        if (length < 0L || blockSize < 0L) {
            throw new IllegalArgumentException("Illegal arguments: length (" + length + "), block size (" + blockSize + ")");
        }
        long blockCount = (long)Math.ceil((double)length / (double)blockSize);
        if (blockCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many blocks: length (" + length + "), block size (" + blockSize + "), total blocks (" + blockCount + ")");
        }
        this.length = length;
        this.blockSize = blockSize;
        this.blockCount = (int)blockCount;
        this.bitmask = new BitSet((int)blockCount);
        long lastBlockSize = length % blockSize;
        if (lastBlockSize > 0L) {
            this.lastBlockSize = lastBlockSize;
            this.lastBlockOffset = length - lastBlockSize;
        } else {
            this.lastBlockSize = blockSize;
            this.lastBlockOffset = length - blockSize;
        }
    }

    @Override
    public int blockCount() {
        return this.blockCount;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long blockSize() {
        return this.blockSize;
    }

    @Override
    public long lastBlockSize() {
        return this.lastBlockSize;
    }

    @Override
    public boolean isPresent(int blockIndex) {
        if (blockIndex < 0 || blockIndex >= this.blockCount) {
            throw new IllegalArgumentException("Invalid block index: " + blockIndex + ". Expected 0.." + (this.blockCount - 1));
        }
        return this.bitmask.get(blockIndex);
    }

    @Override
    public boolean isComplete() {
        return this.bitmask.cardinality() == this.blockCount;
    }

    @Override
    public boolean isEmpty() {
        return this.bitmask.isEmpty();
    }

    protected void markAvailable(long offset, long length) {
        int numberOfBlocks;
        if (offset <= this.lastBlockOffset && offset + length >= this.length()) {
            this.bitmask.set(this.blockCount - 1);
        }
        if (length >= this.blockSize && (numberOfBlocks = (int)Math.floor((double)length / (double)this.blockSize)) > 0) {
            int firstBlockIndex = (int)Math.ceil((double)offset / (double)this.blockSize);
            int lastBlockIndex = (int)Math.floor((double)(offset + length) / (double)this.blockSize) - 1;
            if (lastBlockIndex >= firstBlockIndex) {
                this.bitmask.set(firstBlockIndex, lastBlockIndex + 1);
            }
        }
    }
}

