/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.BlockSet;
import bt.data.DataRange;
import bt.data.range.BlockRange;
import bt.data.range.DelegatingDataRange;
import bt.data.range.DelegatingRange;
import bt.data.range.Range;
import bt.data.range.SynchronizedBlockSet;
import bt.data.range.SynchronizedDataRange;
import bt.data.range.SynchronizedRange;
import java.util.function.Function;

public class Ranges {
    public static <T extends Range<T>> BlockRange<T> blockRange(T range, long blockSize) {
        return new BlockRange(range, blockSize);
    }

    public static <T extends Range<T>> Range<T> synchronizedRange(T range) {
        return new SynchronizedRange(range);
    }

    public static DataRange synchronizedDataRange(DataRange range) {
        SynchronizedRange<DataRange> synchronizedRange = new SynchronizedRange<DataRange>(range);
        return new SynchronizedDataRange<DataRange>(synchronizedRange, Function.identity());
    }

    public static DataRange dataRange(BlockRange<DataRange> range) {
        return DelegatingDataRange.range(range, DelegatingRange::getDelegate);
    }

    public static DataRange synchronizedDataRange(BlockRange<DataRange> range) {
        SynchronizedRange<DataRange> synchronizedRange = new SynchronizedRange<DataRange>(range);
        return new SynchronizedDataRange<BlockRange>(synchronizedRange, BlockRange::getDelegate);
    }

    public static BlockSet synchronizedBlockSet(BlockSet blockSet) {
        return new SynchronizedBlockSet(blockSet);
    }
}

