/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.BlockSet;
import java.util.concurrent.locks.ReentrantLock;

class SynchronizedBlockSet
implements BlockSet {
    private final BlockSet delegate;
    private final ReentrantLock lock;

    SynchronizedBlockSet(BlockSet delegate) {
        this.delegate = delegate;
        this.lock = new ReentrantLock();
    }

    @Override
    public int blockCount() {
        return this.delegate.blockCount();
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public long blockSize() {
        return this.delegate.blockSize();
    }

    @Override
    public long lastBlockSize() {
        return this.delegate.lastBlockSize();
    }

    @Override
    public boolean isPresent(int blockIndex) {
        this.lock.lock();
        try {
            boolean bl = this.delegate.isPresent(blockIndex);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isComplete() {
        this.lock.lock();
        try {
            boolean bl = this.delegate.isComplete();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

