/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.DataRange;
import bt.data.DataRangeVisitor;
import bt.data.range.DelegatingRange;
import bt.data.range.Range;
import bt.data.range.SynchronizedRange;
import java.util.function.Function;

class SynchronizedDataRange<T extends Range<T>>
implements DataRange,
DelegatingRange<T> {
    private SynchronizedRange<T> delegate;
    private Function<T, DataRange> converter;

    SynchronizedDataRange(SynchronizedRange<T> delegate, Function<T, DataRange> converter) {
        this.delegate = delegate;
        this.converter = converter;
    }

    @Override
    public void visitUnits(DataRangeVisitor visitor) {
        this.delegate.getLock().writeLock().lock();
        try {
            this.converter.apply(this.delegate.getDelegate()).visitUnits(visitor);
        }
        finally {
            this.delegate.getLock().writeLock().unlock();
        }
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public DataRange getSubrange(long offset, long length) {
        return new SynchronizedDataRange<T>(this.delegate.getSubrange(offset, length), this.converter);
    }

    @Override
    public DataRange getSubrange(long offset) {
        return new SynchronizedDataRange<T>(this.delegate.getSubrange(offset), this.converter);
    }

    @Override
    public byte[] getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public void putBytes(byte[] block) {
        this.delegate.putBytes(block);
    }

    @Override
    public T getDelegate() {
        return this.delegate.getDelegate();
    }
}

