/*
 * Decompiled with CFR 0.152.
 */
package bt.data.range;

import bt.data.range.DelegatingRange;
import bt.data.range.Range;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class SynchronizedRange<T extends Range<T>>
implements Range<T>,
DelegatingRange<T> {
    private final Range<T> delegate;
    private final ReadWriteLock lock;

    SynchronizedRange(Range<T> delegate) {
        this.delegate = delegate;
        this.lock = new ReentrantReadWriteLock();
    }

    private SynchronizedRange(Range<T> delegate, ReadWriteLock lock) {
        this.delegate = delegate;
        this.lock = lock;
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public SynchronizedRange<T> getSubrange(long offset, long length) {
        return new SynchronizedRange<T>(this.delegate.getSubrange(offset, length), this.lock);
    }

    @Override
    public SynchronizedRange<T> getSubrange(long offset) {
        return new SynchronizedRange<T>(this.delegate.getSubrange(offset), this.lock);
    }

    @Override
    public byte[] getBytes() {
        this.lock.readLock().lock();
        try {
            byte[] byArray = this.delegate.getBytes();
            return byArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void putBytes(byte[] block) {
        this.lock.writeLock().lock();
        try {
            this.delegate.putBytes(block);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public T getDelegate() {
        return (T)this.delegate;
    }
}

