/*
 * Decompiled with CFR 0.152.
 */
package bt.event;

import bt.event.Event;

public abstract class BaseEvent
implements Comparable<BaseEvent>,
Event {
    private final long id;
    private final Object objectId;
    private final long timestamp;

    protected BaseEvent(long id, long timestamp) {
        if (id <= 0L || timestamp <= 0L) {
            throw new IllegalArgumentException("Invalid arguments: id (" + id + "), timestamp (" + timestamp + ")");
        }
        this.id = id;
        this.objectId = id;
        this.timestamp = timestamp;
    }

    @Override
    public Object getId() {
        return this.objectId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(BaseEvent that) {
        return (int)(this.id - that.id);
    }

    public int hashCode() {
        return this.objectId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof BaseEvent)) {
            return false;
        }
        BaseEvent that = (BaseEvent)o;
        return this.id == that.id;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] id {" + this.id + "}, timestamp {" + this.timestamp + "}";
    }
}

