/*
 * Decompiled with CFR 0.152.
 */
package bt.event;

import bt.data.Bitfield;
import bt.event.BaseEvent;
import bt.event.EventSink;
import bt.event.EventSource;
import bt.event.PeerBitfieldUpdatedEvent;
import bt.event.PeerConnectedEvent;
import bt.event.PeerDisconnectedEvent;
import bt.event.PeerDiscoveredEvent;
import bt.event.TorrentStartedEvent;
import bt.event.TorrentStoppedEvent;
import bt.metainfo.TorrentId;
import bt.net.Peer;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus
implements EventSink,
EventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBus.class);
    private final ConcurrentMap<Class<? extends BaseEvent>, Collection<Consumer<? extends BaseEvent>>> listeners = new ConcurrentHashMap<Class<? extends BaseEvent>, Collection<Consumer<? extends BaseEvent>>>();
    private final ReentrantReadWriteLock eventLock = new ReentrantReadWriteLock();
    private long idSequence;

    @Override
    public synchronized void firePeerDiscovered(TorrentId torrentId, Peer peer) {
        long timestamp = System.currentTimeMillis();
        if (this.hasListeners(PeerDiscoveredEvent.class)) {
            long id = this.nextId();
            this.fireEvent(new PeerDiscoveredEvent(id, timestamp, torrentId, peer));
        }
    }

    @Override
    public synchronized void firePeerConnected(TorrentId torrentId, Peer peer) {
        long timestamp = System.currentTimeMillis();
        if (this.hasListeners(PeerConnectedEvent.class)) {
            long id = this.nextId();
            this.fireEvent(new PeerConnectedEvent(id, timestamp, torrentId, peer));
        }
    }

    @Override
    public synchronized void firePeerDisconnected(TorrentId torrentId, Peer peer) {
        long timestamp = System.currentTimeMillis();
        if (this.hasListeners(PeerDisconnectedEvent.class)) {
            long id = this.nextId();
            this.fireEvent(new PeerDisconnectedEvent(id, timestamp, torrentId, peer));
        }
    }

    @Override
    public void firePeerBitfieldUpdated(TorrentId torrentId, Peer peer, Bitfield bitfield) {
        long timestamp = System.currentTimeMillis();
        if (this.hasListeners(PeerBitfieldUpdatedEvent.class)) {
            long id = this.nextId();
            this.fireEvent(new PeerBitfieldUpdatedEvent(id, timestamp, torrentId, peer, bitfield));
        }
    }

    @Override
    public void fireTorrentStarted(TorrentId torrentId) {
        long timestamp = System.currentTimeMillis();
        if (this.hasListeners(TorrentStartedEvent.class)) {
            long id = this.nextId();
            this.fireEvent(new TorrentStartedEvent(id, timestamp, torrentId));
        }
    }

    @Override
    public void fireTorrentStopped(TorrentId torrentId) {
        long timestamp = System.currentTimeMillis();
        if (this.hasListeners(TorrentStoppedEvent.class)) {
            long id = this.nextId();
            this.fireEvent(new TorrentStoppedEvent(id, timestamp, torrentId));
        }
    }

    private boolean hasListeners(Class<? extends BaseEvent> eventType) {
        Collection listeners = (Collection)this.listeners.get(eventType);
        return listeners != null && !listeners.isEmpty();
    }

    private synchronized long nextId() {
        return ++this.idSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BaseEvent> void fireEvent(E event) {
        this.eventLock.readLock().lock();
        try {
            Collection listeners = (Collection)this.listeners.get(event.getClass());
            if (LOGGER.isTraceEnabled()) {
                int count = listeners == null ? 0 : listeners.size();
                LOGGER.trace("Firing event: {}. Listeners count: {}", event, (Object)count);
            }
            if (listeners != null && !listeners.isEmpty()) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    Consumer listener;
                    Consumer _listener = listener = (Consumer)iterator.next();
                    _listener.accept(event);
                }
            }
        }
        finally {
            this.eventLock.readLock().unlock();
        }
    }

    @Override
    public EventSource onPeerDiscovered(Consumer<PeerDiscoveredEvent> listener) {
        this.addListener(PeerDiscoveredEvent.class, listener);
        return this;
    }

    @Override
    public EventSource onPeerConnected(Consumer<PeerConnectedEvent> listener) {
        this.addListener(PeerConnectedEvent.class, listener);
        return this;
    }

    @Override
    public EventSource onPeerDisconnected(Consumer<PeerDisconnectedEvent> listener) {
        this.addListener(PeerDisconnectedEvent.class, listener);
        return this;
    }

    @Override
    public EventSource onPeerBitfieldUpdated(Consumer<PeerBitfieldUpdatedEvent> listener) {
        this.addListener(PeerBitfieldUpdatedEvent.class, listener);
        return this;
    }

    @Override
    public EventSource onTorrentStarted(Consumer<TorrentStartedEvent> listener) {
        this.addListener(TorrentStartedEvent.class, listener);
        return this;
    }

    @Override
    public EventSource onTorrentStopped(Consumer<TorrentStoppedEvent> listener) {
        this.addListener(TorrentStoppedEvent.class, listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BaseEvent> void addListener(Class<E> eventType, Consumer<E> listener) {
        Collection existing;
        Collection listeners = (ConcurrentHashMap.KeySetView)this.listeners.get(eventType);
        if (listeners == null && (existing = (Collection)this.listeners.putIfAbsent(eventType, listeners = ConcurrentHashMap.newKeySet())) != null) {
            listeners = existing;
        }
        this.eventLock.writeLock().lock();
        try {
            Consumer<BaseEvent> safeListener = event -> {
                try {
                    listener.accept(event);
                }
                catch (Exception ex) {
                    LOGGER.error("Listener invocation failed", (Throwable)ex);
                }
            };
            listeners.add(safeListener);
        }
        finally {
            this.eventLock.writeLock().unlock();
        }
    }
}

