/*
 * Decompiled with CFR 0.152.
 */
package bt.magnet;

import bt.magnet.MagnetUri;
import bt.metainfo.TorrentId;
import bt.net.InetPeerAddress;
import bt.protocol.Protocols;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagnetUriParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MagnetUriParser.class);
    private static final String SCHEME = "magnet";
    private static final String INFOHASH_PREFIX = "urn:btih:";
    private static final String MULTIHASH_PREFIX = "urn:btmh:";
    private final boolean lenient;

    public static MagnetUriParser parser() {
        return new MagnetUriParser(false);
    }

    public static MagnetUriParser lenientParser() {
        return new MagnetUriParser(true);
    }

    private MagnetUriParser(boolean lenient) {
        this.lenient = lenient;
    }

    public MagnetUri parse(String uriString) {
        try {
            return this.parse(new URI(uriString));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + uriString, e);
        }
    }

    public MagnetUri parse(URI uri) {
        if (!SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("Invalid scheme: " + uri.getScheme());
        }
        Map<String, List<String>> paramsMap = this.collectParams(uri);
        Set infoHashes = this.getRequiredParam("xt", paramsMap).stream().filter(value -> value.startsWith(INFOHASH_PREFIX)).map(value -> value.substring(INFOHASH_PREFIX.length())).collect(Collectors.toSet());
        if (infoHashes.size() != 1) {
            throw new IllegalStateException(String.format("Parameter '%s' has invalid number of values with prefix '%s': %s", "xt", INFOHASH_PREFIX, infoHashes.size()));
        }
        TorrentId torrentId = this.buildTorrentId((String)infoHashes.iterator().next());
        MagnetUri.Builder builder = MagnetUri.torrentId(torrentId);
        this.getOptionalParam("dn", paramsMap).stream().findAny().ifPresent(builder::name);
        this.getOptionalParam("tr", paramsMap).forEach(builder::tracker);
        this.getOptionalParam("x.pe", paramsMap).forEach(value -> {
            try {
                builder.peer(this.parsePeer((String)value));
            }
            catch (Exception e) {
                if (this.lenient) {
                    LOGGER.warn("Failed to parse peer address: " + value, (Throwable)e);
                }
                throw new RuntimeException("Failed to parse peer address: " + value, e);
            }
        });
        return builder.buildUri();
    }

    private Map<String, List<String>> collectParams(URI uri) {
        String[] params;
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        for (String param : params = uri.getSchemeSpecificPart().substring(1).split("&")) {
            String[] parts = param.split("=");
            String name = parts[0];
            String value = parts[1];
            ArrayList<String> values = (ArrayList<String>)paramsMap.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                paramsMap.put(name, values);
            }
            values.add(value);
        }
        return paramsMap;
    }

    private List<String> getRequiredParam(String paramName, Map<String, List<String>> paramsMap) {
        List<String> values = paramsMap.getOrDefault(paramName, Collections.emptyList());
        if (values.isEmpty()) {
            throw new IllegalStateException(String.format("Required parameter '%s' is missing: %s", paramName, values.size()));
        }
        return values;
    }

    private List<String> getOptionalParam(String paramName, Map<String, List<String>> paramsMap) {
        return paramsMap.getOrDefault(paramName, Collections.emptyList());
    }

    private TorrentId buildTorrentId(String infoHash) {
        int len = infoHash.length();
        if (len != 40) {
            if (len == 32) {
                throw new IllegalArgumentException("Base32 info hash not supported");
            }
            throw new IllegalArgumentException("Invalid info hash length: " + len);
        }
        byte[] bytes = Protocols.fromHex(infoHash);
        return TorrentId.fromBytes(bytes);
    }

    private InetPeerAddress parsePeer(String value) throws Exception {
        String[] parts = value.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid peer format: " + value + "; should be <host>:<port>");
        }
        String hostname = parts[0];
        int port = Integer.valueOf(parts[1]);
        return new InetPeerAddress(hostname, port);
    }

    private static class UriParams {
        private static final String TORRENT_ID = "xt";
        private static final String DISPLAY_NAME = "dn";
        private static final String TRACKER_URL = "tr";
        private static final String PEER = "x.pe";

        private UriParams() {
        }
    }
}

