/*
 * Decompiled with CFR 0.152.
 */
package bt.magnet;

import bt.bencoding.BEParser;
import bt.bencoding.model.BEInteger;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.magnet.UtMetadata;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.handler.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UtMetadataMessageHandler
implements MessageHandler<UtMetadata> {
    private final Collection<Class<? extends UtMetadata>> supportedTypes = Collections.singleton(UtMetadata.class);

    @Override
    public boolean encode(EncodingContext context, UtMetadata message, ByteBuffer buffer) {
        boolean encoded = false;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            this.writeMessage(message, bos);
            byte[] payload = bos.toByteArray();
            if (buffer.remaining() >= payload.length) {
                buffer.put(payload);
                encoded = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return encoded;
    }

    private void writeMessage(final UtMetadata message, OutputStream out) throws IOException {
        BEMap m = new BEMap(null, (Map)new HashMap<String, BEObject<?>>(){
            {
                this.put(UtMetadata.messageTypeField(), new BEInteger(null, BigInteger.valueOf(message.getType().id())));
                this.put(UtMetadata.pieceIndexField(), new BEInteger(null, BigInteger.valueOf(message.getPieceIndex())));
                if (message.getData().isPresent()) {
                    this.put(UtMetadata.totalSizeField(), new BEInteger(null, BigInteger.valueOf(message.getTotalSize().get().intValue())));
                }
            }
        });
        m.writeTo(out);
        if (message.getData().isPresent()) {
            out.write(message.getData().get());
        }
    }

    @Override
    public int decode(DecodingContext context, ByteBuffer buffer) {
        byte[] payload = new byte[buffer.remaining()];
        buffer.get(payload);
        Throwable throwable = null;
        try (BEParser parser = new BEParser(payload);){
            BEMap m = parser.readMap();
            int length = m.getContent().length;
            UtMetadata.Type messageType = this.getMessageType(m);
            int pieceIndex = this.getPieceIndex(m);
            switch (messageType) {
                case REQUEST: {
                    context.setMessage(UtMetadata.request(pieceIndex));
                    int n = length;
                    return n;
                }
                case DATA: {
                    byte[] data = Arrays.copyOfRange(payload, length, payload.length);
                    context.setMessage(UtMetadata.data(pieceIndex, this.getTotalSize(m), data));
                    int n = payload.length;
                    return n;
                }
                case REJECT: {
                    context.setMessage(UtMetadata.reject(pieceIndex));
                    int n = length;
                    return n;
                }
            }
            try {
                throw new IllegalStateException("Unknown message type: " + messageType.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private UtMetadata.Type getMessageType(BEMap m) {
        BEInteger type = (BEInteger)m.getValue().get(UtMetadata.messageTypeField());
        int typeId = type.getValue().intValueExact();
        return UtMetadata.Type.forId(typeId);
    }

    private int getPieceIndex(BEMap m) {
        return this.getIntAttribute(UtMetadata.pieceIndexField(), m);
    }

    private int getTotalSize(BEMap m) {
        return this.getIntAttribute(UtMetadata.totalSizeField(), m);
    }

    private int getIntAttribute(String name, BEMap m) {
        BEInteger value = (BEInteger)m.getValue().get(name);
        if (value == null) {
            throw new IllegalStateException("Message attribute is missing: " + name);
        }
        return value.getValue().intValueExact();
    }

    @Override
    public Collection<Class<? extends UtMetadata>> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public Class<? extends UtMetadata> readMessageType(ByteBuffer buffer) {
        return UtMetadata.class;
    }
}

