/*
 * Decompiled with CFR 0.152.
 */
package bt.metainfo;

import bt.BtException;
import bt.metainfo.DefaultTorrentFile;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentFile;
import bt.metainfo.TorrentId;
import bt.metainfo.TorrentSource;
import bt.tracker.AnnounceKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

class DefaultTorrent
implements Torrent {
    private static final int CHUNK_HASH_LENGTH = 20;
    private TorrentSource source;
    private Optional<AnnounceKey> announceKey;
    private TorrentId torrentId;
    private String name;
    private long chunkSize;
    private byte[] chunkHashes;
    private long size;
    private List<TorrentFile> files;
    private boolean isPrivate;
    private Optional<Instant> creationDate;
    private Optional<String> createdBy;

    DefaultTorrent(TorrentSource source) {
        this.source = source;
        this.announceKey = Optional.empty();
        this.creationDate = Optional.empty();
        this.createdBy = Optional.empty();
    }

    @Override
    public TorrentSource getSource() {
        return this.source;
    }

    @Override
    public Optional<AnnounceKey> getAnnounceKey() {
        return this.announceKey;
    }

    @Override
    public TorrentId getTorrentId() {
        return this.torrentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public Iterable<byte[]> getChunkHashes() {
        return () -> new Iterator<byte[]>(){
            private int read;

            @Override
            public boolean hasNext() {
                return this.read < DefaultTorrent.this.chunkHashes.length;
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int start = this.read;
                this.read += 20;
                return Arrays.copyOfRange(DefaultTorrent.this.chunkHashes, start, this.read);
            }
        };
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public List<TorrentFile> getFiles() {
        if (this.files == null) {
            DefaultTorrentFile file = new DefaultTorrentFile();
            file.setSize(this.getSize());
            file.setPathElements(Collections.singletonList(this.getName()));
            return Collections.singletonList(file);
        }
        return Collections.unmodifiableList(this.files);
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public Optional<Instant> getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Optional<String> getCreatedBy() {
        return this.createdBy;
    }

    void setAnnounceKey(AnnounceKey announceKey) {
        this.announceKey = Optional.of(announceKey);
    }

    void setTorrentId(TorrentId torrentId) {
        this.torrentId = torrentId;
    }

    void setName(String name) {
        this.name = name;
    }

    void setChunkSize(long chunkSize) {
        if (chunkSize <= 0L) {
            throw new BtException("Invalid chunk size: " + chunkSize);
        }
        this.chunkSize = chunkSize;
    }

    void setSize(long size) {
        if (size < 0L) {
            throw new BtException("Invalid torrent size: " + size);
        }
        this.size = size;
    }

    void setFiles(List<TorrentFile> files) {
        if (files == null || files.isEmpty()) {
            throw new BtException("Can't create torrent without files");
        }
        this.files = files;
    }

    public void setChunkHashes(byte[] chunkHashes) {
        if (chunkHashes.length % 20 != 0) {
            throw new BtException("Invalid chunk hashes string -- length (" + chunkHashes.length + ") is not divisible by " + 20);
        }
        this.chunkHashes = chunkHashes;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setCreationDate(Instant creationDate) {
        this.creationDate = Optional.of(creationDate);
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = Optional.of(createdBy);
    }

    public String toString() {
        return this.name;
    }
}

