/*
 * Decompiled with CFR 0.152.
 */
package bt.metainfo;

import bt.BtException;
import bt.bencoding.BEParser;
import bt.bencoding.BEType;
import bt.bencoding.model.BEList;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEObjectModel;
import bt.bencoding.model.BEString;
import bt.bencoding.model.ValidationResult;
import bt.bencoding.model.YamlBEObjectModelLoader;
import bt.metainfo.DefaultTorrent;
import bt.metainfo.DefaultTorrentFile;
import bt.metainfo.IMetadataService;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentFile;
import bt.metainfo.TorrentId;
import bt.metainfo.TorrentSource;
import bt.service.CryptoUtil;
import bt.tracker.AnnounceKey;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataService
implements IMetadataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataService.class);
    private static final String ANNOUNCE_KEY = "announce";
    private static final String ANNOUNCE_LIST_KEY = "announce-list";
    private static final String INFOMAP_KEY = "info";
    private static final String TORRENT_NAME_KEY = "name";
    private static final String CHUNK_SIZE_KEY = "piece length";
    private static final String CHUNK_HASHES_KEY = "pieces";
    private static final String TORRENT_SIZE_KEY = "length";
    private static final String FILES_KEY = "files";
    private static final String FILE_SIZE_KEY = "length";
    private static final String FILE_PATH_ELEMENTS_KEY = "path";
    private static final String PRIVATE_KEY = "private";
    private static final String CREATION_DATE_KEY = "creation date";
    private static final String CREATED_BY_KEY = "created by";
    private BEObjectModel torrentModel;
    private BEObjectModel infodictModel;
    private Charset defaultCharset = Charset.forName("UTF-8");

    public MetadataService() {
        try {
            try (InputStream in = MetadataService.class.getResourceAsStream("/metainfo.yml");){
                this.torrentModel = new YamlBEObjectModelLoader().load(in);
            }
            in = MetadataService.class.getResourceAsStream("/infodict.yml");
            var2_3 = null;
            try {
                this.infodictModel = new YamlBEObjectModelLoader().load(in);
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (var2_3 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BtException("Failed to create metadata service", e);
        }
    }

    @Override
    public Torrent fromUrl(URL url) {
        try (BEParser parser = new BEParser(url);){
            Torrent torrent = this.buildTorrent(parser);
            return torrent;
        }
    }

    @Override
    public Torrent fromInputStream(InputStream in) {
        try (BEParser parser = new BEParser(in);){
            Torrent torrent = this.buildTorrent(parser);
            return torrent;
        }
    }

    @Override
    public Torrent fromByteArray(byte[] bs) {
        try (BEParser parser = new BEParser(bs);){
            Torrent torrent = this.buildTorrent(parser);
            return torrent;
        }
    }

    private Torrent buildTorrent(BEParser parser) {
        TorrentSource source;
        BEMap infoDictionary;
        ValidationResult infodictValidationResult;
        if (parser.readType() != BEType.MAP) {
            throw new BtException("Invalid metainfo format -- expected a map, got: " + parser.readType().name().toLowerCase());
        }
        final BEMap metadata = parser.readMap();
        ValidationResult validationResult = this.torrentModel.validate((Object)metadata);
        if (!validationResult.isSuccess() && !(infodictValidationResult = this.infodictModel.validate((Object)metadata)).isSuccess()) {
            throw new BtException("Validation failed for torrent metainfo:\n1. Standard torrent model: " + Arrays.toString(validationResult.getMessages().toArray()) + "\n2. Standalone info dictionary model: " + Arrays.toString(infodictValidationResult.getMessages().toArray()));
        }
        Map root = metadata.getValue();
        if (root.containsKey(INFOMAP_KEY)) {
            infoDictionary = (BEMap)root.get(INFOMAP_KEY);
            source = new TorrentSource(){

                @Override
                public Optional<byte[]> getMetadata() {
                    return Optional.of(metadata.getContent());
                }

                @Override
                public byte[] getExchangedMetadata() {
                    return infoDictionary.getContent();
                }
            };
        } else {
            infoDictionary = metadata;
            source = new TorrentSource(){

                @Override
                public Optional<byte[]> getMetadata() {
                    return Optional.empty();
                }

                @Override
                public byte[] getExchangedMetadata() {
                    return infoDictionary.getContent();
                }
            };
        }
        DefaultTorrent torrent = new DefaultTorrent(source);
        try {
            torrent.setTorrentId(TorrentId.fromBytes(CryptoUtil.getSha1Digest(infoDictionary.getContent())));
            Map infoMap = infoDictionary.getValue();
            if (infoMap.get(TORRENT_NAME_KEY) != null) {
                byte[] name = (byte[])((BEObject)infoMap.get(TORRENT_NAME_KEY)).getValue();
                torrent.setName(new String(name, this.defaultCharset));
            }
            BigInteger chunkSize = (BigInteger)((BEObject)infoMap.get(CHUNK_SIZE_KEY)).getValue();
            torrent.setChunkSize(chunkSize.longValueExact());
            byte[] chunkHashes = (byte[])((BEObject)infoMap.get(CHUNK_HASHES_KEY)).getValue();
            torrent.setChunkHashes(chunkHashes);
            if (infoMap.get("length") != null) {
                BigInteger torrentSize = (BigInteger)((BEObject)infoMap.get("length")).getValue();
                torrent.setSize(torrentSize.longValueExact());
            } else {
                List files = (List)((BEObject)infoMap.get(FILES_KEY)).getValue();
                ArrayList<TorrentFile> torrentFiles = new ArrayList<TorrentFile>(files.size() + 1);
                BigInteger torrentSize = BigInteger.ZERO;
                for (BEMap file : files) {
                    Map fileMap = file.getValue();
                    DefaultTorrentFile torrentFile = new DefaultTorrentFile();
                    BigInteger fileSize = (BigInteger)((BEObject)fileMap.get("length")).getValue();
                    torrentFile.setSize(fileSize.longValueExact());
                    torrentSize = torrentSize.add(fileSize);
                    List pathElements = (List)((BEObject)fileMap.get(FILE_PATH_ELEMENTS_KEY)).getValue();
                    torrentFile.setPathElements(pathElements.stream().map(bytes -> bytes.getValue(this.defaultCharset)).collect(Collectors.toList()));
                    torrentFiles.add(torrentFile);
                }
                torrent.setFiles(torrentFiles);
                torrent.setSize(torrentSize.longValueExact());
            }
            boolean isPrivate = false;
            if (infoMap.get(PRIVATE_KEY) != null && BigInteger.ONE.equals(((BEObject)infoMap.get(PRIVATE_KEY)).getValue())) {
                torrent.setPrivate(true);
                isPrivate = true;
            }
            if (root.get(CREATION_DATE_KEY) != null) {
                BigInteger epochMilli = (BigInteger)((BEObject)root.get(CREATION_DATE_KEY)).getValue();
                torrent.setCreationDate(Instant.ofEpochMilli((long)epochMilli.intValueExact() * 1000L));
            }
            if (root.get(CREATED_BY_KEY) != null) {
                byte[] createdBy = (byte[])((BEObject)root.get(CREATED_BY_KEY)).getValue();
                torrent.setCreatedBy(new String(createdBy, this.defaultCharset));
            }
            AnnounceKey announceKey = null;
            if (!isPrivate && root.containsKey(ANNOUNCE_LIST_KEY)) {
                BEList announceList = (BEList)root.get(ANNOUNCE_LIST_KEY);
                List tierList = announceList.getValue();
                ArrayList<List<String>> trackerUrls = new ArrayList<List<String>>(tierList.size() + 1);
                for (BEList tierElement : tierList) {
                    List trackerUrlList = tierElement.getValue();
                    ArrayList<String> tierTackerUrls = new ArrayList<String>(trackerUrlList.size() + 1);
                    for (BEString trackerUrlElement : trackerUrlList) {
                        tierTackerUrls.add(trackerUrlElement.getValue(this.defaultCharset));
                    }
                    trackerUrls.add(tierTackerUrls);
                }
                announceKey = new AnnounceKey(trackerUrls);
            } else if (root.containsKey(ANNOUNCE_KEY)) {
                byte[] trackerUrl = (byte[])((BEObject)root.get(ANNOUNCE_KEY)).getValue();
                announceKey = new AnnounceKey(new String(trackerUrl, this.defaultCharset));
            }
            if (announceKey != null) {
                torrent.setAnnounceKey(announceKey);
            }
        }
        catch (Exception e) {
            throw new BtException("Invalid metainfo format", e);
        }
        return torrent;
    }
}

