/*
 * Decompiled with CFR 0.152.
 */
package bt.metainfo;

import bt.BtException;
import bt.protocol.Protocols;
import java.util.Arrays;
import java.util.Objects;

public class TorrentId {
    private static final int TORRENT_ID_LENGTH = 20;
    private final byte[] torrentId;

    public static int length() {
        return 20;
    }

    public static TorrentId fromBytes(byte[] bytes) {
        return new TorrentId(bytes);
    }

    private TorrentId(byte[] torrentId) {
        Objects.requireNonNull(torrentId);
        if (torrentId.length != 20) {
            throw new BtException("Illegal torrent ID length: " + torrentId.length);
        }
        this.torrentId = torrentId;
    }

    public byte[] getBytes() {
        return this.torrentId;
    }

    public int hashCode() {
        return Arrays.hashCode(this.torrentId);
    }

    public boolean equals(Object obj) {
        if (obj == null || !TorrentId.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        return obj == this || Arrays.equals(this.torrentId, ((TorrentId)obj).getBytes());
    }

    public String toString() {
        return Protocols.toHex(this.torrentId);
    }
}

