/*
 * Decompiled with CFR 0.152.
 */
package bt.module;

import bt.module.ExtendedMessageHandlers;
import bt.module.MessageHandlers;
import bt.net.HandshakeHandler;
import bt.protocol.Message;
import bt.protocol.extended.ExtendedMessage;
import bt.protocol.handler.MessageHandler;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;

public class ProtocolModuleExtender {
    private final Binder binder;
    private MapBinder<Integer, MessageHandler<? extends Message>> messageHandlers;
    private MapBinder<String, MessageHandler<? extends ExtendedMessage>> extendedMessageHandlers;
    private Multibinder<HandshakeHandler> handshakeHandlers;

    ProtocolModuleExtender(Binder binder) {
        this.binder = binder;
    }

    ProtocolModuleExtender initAllExtensions() {
        this.contributeMessageHandlers();
        this.contributeExtendedMessageHandlers();
        this.contributeHandshakeHandlers();
        return this;
    }

    public <M extends Message> ProtocolModuleExtender addMessageHandler(int messageType, Class<? extends MessageHandler<M>> handlerType) {
        Objects.requireNonNull(handlerType);
        this.contributeMessageHandlers().addBinding((Object)messageType).to(handlerType).in(Singleton.class);
        return this;
    }

    public <M extends Message> ProtocolModuleExtender addMessageHandler(int messageType, MessageHandler<M> handler) {
        Objects.requireNonNull(handler);
        this.contributeMessageHandlers().addBinding((Object)messageType).toInstance(handler);
        return this;
    }

    public <M extends ExtendedMessage> ProtocolModuleExtender addExtendedMessageHandler(String messageType, Class<? extends MessageHandler<M>> handlerType) {
        Objects.requireNonNull(messageType);
        Objects.requireNonNull(handlerType);
        this.contributeExtendedMessageHandlers().addBinding((Object)messageType).to(handlerType).in(Singleton.class);
        return this;
    }

    public <M extends ExtendedMessage> ProtocolModuleExtender addExtendedMessageHandler(String messageType, MessageHandler<M> handler) {
        Objects.requireNonNull(messageType);
        Objects.requireNonNull(handler);
        this.contributeExtendedMessageHandlers().addBinding((Object)messageType).toInstance(handler);
        return this;
    }

    public ProtocolModuleExtender addHandshakeHandler(Class<? extends HandshakeHandler> handlerType) {
        Objects.requireNonNull(handlerType);
        this.contributeHandshakeHandlers().addBinding().to(handlerType).in(Singleton.class);
        return this;
    }

    public ProtocolModuleExtender addHandshakeHandler(HandshakeHandler handler) {
        Objects.requireNonNull(handler);
        this.contributeHandshakeHandlers().addBinding().toInstance((Object)handler);
        return this;
    }

    private MapBinder<Integer, MessageHandler<? extends Message>> contributeMessageHandlers() {
        if (this.messageHandlers == null) {
            this.messageHandlers = MapBinder.newMapBinder((Binder)this.binder, (TypeLiteral)new TypeLiteral<Integer>(){}, (TypeLiteral)new TypeLiteral<MessageHandler<?>>(){}, MessageHandlers.class);
        }
        return this.messageHandlers;
    }

    private MapBinder<String, MessageHandler<? extends ExtendedMessage>> contributeExtendedMessageHandlers() {
        if (this.extendedMessageHandlers == null) {
            this.extendedMessageHandlers = MapBinder.newMapBinder((Binder)this.binder, (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<MessageHandler<? extends ExtendedMessage>>(){}, ExtendedMessageHandlers.class);
        }
        return this.extendedMessageHandlers;
    }

    private Multibinder<HandshakeHandler> contributeHandshakeHandlers() {
        if (this.handshakeHandlers == null) {
            this.handshakeHandlers = Multibinder.newSetBinder((Binder)this.binder, HandshakeHandler.class);
        }
        return this.handshakeHandlers;
    }
}

