/*
 * Decompiled with CFR 0.152.
 */
package bt.module;

import bt.data.ChunkVerifier;
import bt.data.DataDescriptorFactory;
import bt.data.DefaultChunkVerifier;
import bt.data.IDataDescriptorFactory;
import bt.data.digest.Digester;
import bt.data.digest.JavaSecurityDigester;
import bt.event.EventBus;
import bt.event.EventSink;
import bt.event.EventSource;
import bt.metainfo.IMetadataService;
import bt.metainfo.MetadataService;
import bt.module.BitTorrentProtocol;
import bt.module.ClientExecutor;
import bt.module.MessagingAgents;
import bt.module.PeerConnectionSelector;
import bt.module.ServiceModuleExtender;
import bt.module.TrackerFactories;
import bt.net.ConnectionSource;
import bt.net.DataReceiver;
import bt.net.DataReceivingLoop;
import bt.net.IConnectionHandlerFactory;
import bt.net.IConnectionSource;
import bt.net.IMessageDispatcher;
import bt.net.IPeerConnectionFactory;
import bt.net.IPeerConnectionPool;
import bt.net.MessageDispatcher;
import bt.net.PeerConnectionFactory;
import bt.net.PeerConnectionPool;
import bt.net.SharedSelector;
import bt.net.SocketChannelConnectionAcceptor;
import bt.net.buffer.BufferManager;
import bt.net.buffer.IBufferManager;
import bt.net.pipeline.ChannelPipelineFactory;
import bt.net.pipeline.IChannelPipelineFactory;
import bt.peer.IPeerCache;
import bt.peer.IPeerRegistry;
import bt.peer.PeerCache;
import bt.peer.PeerRegistry;
import bt.peer.PeerSourceFactory;
import bt.processor.ProcessorFactory;
import bt.processor.TorrentProcessorFactory;
import bt.protocol.Message;
import bt.protocol.handler.MessageHandler;
import bt.runtime.Config;
import bt.service.ApplicationService;
import bt.service.ClasspathApplicationService;
import bt.service.ExecutorServiceProvider;
import bt.service.IRuntimeLifecycleBinder;
import bt.service.IdentityService;
import bt.service.LifecycleBinding;
import bt.service.RuntimeLifecycleBinder;
import bt.service.VersionAwareIdentityService;
import bt.torrent.AdhocTorrentRegistry;
import bt.torrent.TorrentRegistry;
import bt.torrent.data.DataWorkerFactory;
import bt.torrent.data.IDataWorkerFactory;
import bt.tracker.ITrackerService;
import bt.tracker.TrackerFactory;
import bt.tracker.TrackerService;
import bt.tracker.udp.UdpTrackerFactory;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.util.concurrent.ExecutorService;

public class ServiceModule
implements Module {
    private Config config;

    public static ServiceModuleExtender extend(Binder binder) {
        return new ServiceModuleExtender(binder);
    }

    @Deprecated
    public static Multibinder<PeerSourceFactory> contributePeerSourceFactory(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, PeerSourceFactory.class);
    }

    @Deprecated
    public static Multibinder<Object> contributeMessagingAgent(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, Object.class, MessagingAgents.class);
    }

    @Deprecated
    public static MapBinder<String, TrackerFactory> contributeTrackerFactory(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, String.class, TrackerFactory.class, TrackerFactories.class);
    }

    public ServiceModule() {
        this.config = new Config();
    }

    public ServiceModule(Config config) {
        this.config = config;
    }

    public void configure(Binder binder) {
        binder.bind(Config.class).toInstance((Object)this.config);
        ServiceModule.extend(binder).initAllExtensions().addTrackerFactory(UdpTrackerFactory.class, "udp", new String[0]).addConnectionAcceptor(SocketChannelConnectionAcceptor.class);
        binder.bind(IMessageDispatcher.class).to(MessageDispatcher.class).asEagerSingleton();
        binder.bind(IConnectionSource.class).to(ConnectionSource.class).asEagerSingleton();
        binder.bind(IPeerConnectionPool.class).to(PeerConnectionPool.class).asEagerSingleton();
        binder.bind(IPeerRegistry.class).to(PeerRegistry.class).asEagerSingleton();
        binder.bind(DataReceiver.class).to(DataReceivingLoop.class).asEagerSingleton();
        binder.bind(IMetadataService.class).to(MetadataService.class).in(Singleton.class);
        binder.bind(ApplicationService.class).to(ClasspathApplicationService.class).in(Singleton.class);
        binder.bind(IdentityService.class).to(VersionAwareIdentityService.class).in(Singleton.class);
        binder.bind(ITrackerService.class).to(TrackerService.class).in(Singleton.class);
        binder.bind(IMetadataService.class).to(MetadataService.class).in(Singleton.class);
        binder.bind(TorrentRegistry.class).to(AdhocTorrentRegistry.class).in(Singleton.class);
        binder.bind(IRuntimeLifecycleBinder.class).to(RuntimeLifecycleBinder.class).in(Singleton.class);
        binder.bind(ProcessorFactory.class).to(TorrentProcessorFactory.class).in(Singleton.class);
        binder.bind(IPeerCache.class).to(PeerCache.class).in(Singleton.class);
        binder.bind(IBufferManager.class).to(BufferManager.class).in(Singleton.class);
        binder.bind(IChannelPipelineFactory.class).to(ChannelPipelineFactory.class).in(Singleton.class);
        binder.bind(EventSink.class).to(EventBus.class).in(Singleton.class);
        binder.bind(EventSource.class).to(EventBus.class).in(Singleton.class);
        binder.bind(ExecutorService.class).annotatedWith(ClientExecutor.class).toProvider(ExecutorServiceProvider.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    public Digester provideDigester() {
        int step = 0x800000;
        return new JavaSecurityDigester("SHA-1", step);
    }

    @Provides
    @Singleton
    public ChunkVerifier provideVerifier(Config config, Digester digester) {
        return new DefaultChunkVerifier(digester, config.getNumOfHashingThreads());
    }

    @Provides
    @Singleton
    public IDataDescriptorFactory provideDataDescriptorFactory(Config config, ChunkVerifier verifier) {
        return new DataDescriptorFactory(verifier, config.getTransferBlockSize());
    }

    @Provides
    @Singleton
    public IDataWorkerFactory provideDataWorkerFactory(IRuntimeLifecycleBinder lifecycleBinder, ChunkVerifier verifier, Config config) {
        return new DataWorkerFactory(lifecycleBinder, verifier, config.getMaxIOQueueSize());
    }

    @Provides
    @Singleton
    public EventBus provideEventBus() {
        return new EventBus();
    }

    @Provides
    @Singleton
    @PeerConnectionSelector
    public SharedSelector provideSelector(IRuntimeLifecycleBinder lifecycleBinder) {
        SharedSelector selector;
        try {
            selector = new SharedSelector(Selector.open());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get I/O selector", e);
        }
        Runnable shutdownRoutine = () -> {
            try {
                selector.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close selector", e);
            }
        };
        lifecycleBinder.addBinding(IRuntimeLifecycleBinder.LifecycleEvent.SHUTDOWN, LifecycleBinding.bind(shutdownRoutine).description("Shutdown selector").build());
        return selector;
    }

    @Provides
    @Singleton
    public IPeerConnectionFactory providePeerConnectionFactory(@PeerConnectionSelector SharedSelector selector, IConnectionHandlerFactory connectionHandlerFactory, @BitTorrentProtocol MessageHandler<Message> bittorrentProtocol, TorrentRegistry torrentRegistry, IChannelPipelineFactory channelPipelineFactory, IBufferManager bufferManager, DataReceiver dataReceiver, EventSource eventSource, Config config) {
        return new PeerConnectionFactory(selector, connectionHandlerFactory, channelPipelineFactory, bittorrentProtocol, torrentRegistry, bufferManager, dataReceiver, eventSource, config);
    }

    @Provides
    @Singleton
    public SocketChannelConnectionAcceptor provideSocketChannelConnectionAcceptor(@PeerConnectionSelector SharedSelector selector, IPeerCache peerCache, IPeerConnectionFactory connectionFactory, Config config) {
        InetSocketAddress localAddress = new InetSocketAddress(config.getAcceptorAddress(), config.getAcceptorPort());
        return new SocketChannelConnectionAcceptor(selector, peerCache, connectionFactory, localAddress);
    }
}

