/*
 * Decompiled with CFR 0.152.
 */
package bt.module;

import bt.module.MessagingAgents;
import bt.module.TrackerFactories;
import bt.net.PeerConnectionAcceptor;
import bt.peer.PeerSourceFactory;
import bt.tracker.TrackerFactory;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;

public class ServiceModuleExtender {
    private final Binder binder;
    private Multibinder<PeerSourceFactory> peerSourceFactories;
    private MapBinder<String, TrackerFactory> trackerFactories;
    private Multibinder<Object> messagingAgents;
    private Multibinder<PeerConnectionAcceptor> connectionAcceptors;

    ServiceModuleExtender(Binder binder) {
        this.binder = binder;
    }

    ServiceModuleExtender initAllExtensions() {
        this.contributePeerSourceFactories();
        this.contributeTrackerFactories();
        this.contributeMessagingAgents();
        this.contributeConnectionAcceptors();
        return this;
    }

    public ServiceModuleExtender addPeerSourceFactory(Class<? extends PeerSourceFactory> factoryType) {
        Objects.requireNonNull(factoryType);
        this.contributePeerSourceFactories().addBinding().to(factoryType).in(Singleton.class);
        return this;
    }

    public ServiceModuleExtender addPeerSourceFactory(PeerSourceFactory factory) {
        Objects.requireNonNull(factory);
        this.contributePeerSourceFactories().addBinding().toInstance((Object)factory);
        return this;
    }

    public ServiceModuleExtender addTrackerFactory(Class<? extends TrackerFactory> factoryType, String protocol, String ... otherProtocols) {
        Objects.requireNonNull(protocol);
        Objects.requireNonNull(otherProtocols);
        Objects.requireNonNull(factoryType);
        this.contributeTrackerFactories().addBinding((Object)protocol).to(factoryType).in(Singleton.class);
        for (String otherProtocol : otherProtocols) {
            Objects.requireNonNull(otherProtocol);
            this.contributeTrackerFactories().addBinding((Object)otherProtocol).to(factoryType).in(Singleton.class);
        }
        return this;
    }

    public ServiceModuleExtender addTrackerFactory(TrackerFactory factory, String protocol, String ... otherProtocols) {
        Objects.requireNonNull(protocol);
        Objects.requireNonNull(otherProtocols);
        Objects.requireNonNull(factory);
        this.contributeTrackerFactories().addBinding((Object)protocol).toInstance((Object)factory);
        for (String otherProtocol : otherProtocols) {
            Objects.requireNonNull(otherProtocol);
            this.contributeTrackerFactories().addBinding((Object)otherProtocol).toInstance((Object)factory);
        }
        return this;
    }

    public ServiceModuleExtender addMessagingAgentType(Class<?> agentType) {
        Objects.requireNonNull(agentType);
        this.contributeMessagingAgents().addBinding().to(agentType).in(Singleton.class);
        return this;
    }

    public ServiceModuleExtender addMessagingAgent(Object agent) {
        Objects.requireNonNull(agent);
        this.contributeMessagingAgents().addBinding().toInstance(agent);
        return this;
    }

    public ServiceModuleExtender addConnectionAcceptor(Class<? extends PeerConnectionAcceptor> connectionAcceptorType) {
        Objects.requireNonNull(connectionAcceptorType);
        this.contributeConnectionAcceptors().addBinding().to(connectionAcceptorType);
        return this;
    }

    public ServiceModuleExtender addConnectionAcceptor(PeerConnectionAcceptor connectionAcceptor) {
        Objects.requireNonNull(connectionAcceptor);
        this.contributeConnectionAcceptors().addBinding().toInstance((Object)connectionAcceptor);
        return this;
    }

    private Multibinder<PeerSourceFactory> contributePeerSourceFactories() {
        if (this.peerSourceFactories == null) {
            this.peerSourceFactories = Multibinder.newSetBinder((Binder)this.binder, PeerSourceFactory.class);
        }
        return this.peerSourceFactories;
    }

    private MapBinder<String, TrackerFactory> contributeTrackerFactories() {
        if (this.trackerFactories == null) {
            this.trackerFactories = MapBinder.newMapBinder((Binder)this.binder, String.class, TrackerFactory.class, TrackerFactories.class);
        }
        return this.trackerFactories;
    }

    private Multibinder<Object> contributeMessagingAgents() {
        if (this.messagingAgents == null) {
            this.messagingAgents = Multibinder.newSetBinder((Binder)this.binder, Object.class, MessagingAgents.class);
        }
        return this.messagingAgents;
    }

    private Multibinder<PeerConnectionAcceptor> contributeConnectionAcceptors() {
        if (this.connectionAcceptors == null) {
            this.connectionAcceptors = Multibinder.newSetBinder((Binder)this.binder, PeerConnectionAcceptor.class);
        }
        return this.connectionAcceptors;
    }
}

