/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BigIntegers {
    public static byte[] encodeUnsigned(BigInteger i, int byteCount) {
        if (byteCount < 1) {
            throw new IllegalArgumentException("Invalid number of bytes: " + byteCount);
        }
        byte[] bytes = i.toByteArray();
        if (bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length > byteCount) {
            throw new IllegalStateException("Value truncation");
        }
        if (bytes.length < byteCount) {
            byte[] bytesCopy = bytes;
            bytes = new byte[byteCount];
            System.arraycopy(bytesCopy, 0, bytes, bytes.length - bytesCopy.length, bytesCopy.length);
        }
        return bytes;
    }

    public static BigInteger decodeUnsigned(ByteBuffer buffer, int length) {
        byte b;
        if (length < 1) {
            throw new IllegalArgumentException("Invalid number of bytes: " + length);
        }
        if (buffer.remaining() < length) {
            throw new IllegalStateException("Insufficient bytes in buffer: " + buffer.remaining() + ", requested: " + length);
        }
        int i = 0;
        while ((b = buffer.get()) == 0 && ++i < length) {
        }
        if (i == length) {
            return BigInteger.ZERO;
        }
        int len = length - i;
        byte[] bytes = new byte[len];
        bytes[0] = b;
        buffer.get(bytes, 1, len - 1);
        return new BigInteger(1, bytes);
    }
}

