/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.net.buffer.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class ByteChannelReader {
    private final ReadableByteChannel channel;
    private final Optional<Duration> timeout;
    private final Optional<Duration> waitBetweenReads;
    private final int min;
    private final int limit;

    public static ByteChannelReader forChannel(ReadableByteChannel channel) {
        return new ByteChannelReader(channel, Optional.empty(), Optional.empty(), 0, Integer.MAX_VALUE);
    }

    public ByteChannelReader withTimeout(Duration timeout) {
        return new ByteChannelReader(this.channel, Optional.of(timeout), this.waitBetweenReads, this.min, this.limit);
    }

    public ByteChannelReader waitBetweenReads(Duration waitBetweenReads) {
        return new ByteChannelReader(this.channel, this.timeout, Optional.of(waitBetweenReads), this.min, this.limit);
    }

    public ByteChannelReader readExactly(int bytes) {
        return new ByteChannelReader(this.channel, this.timeout, this.waitBetweenReads, bytes, bytes);
    }

    public ByteChannelReader readAtLeast(int minBytes) {
        return new ByteChannelReader(this.channel, this.timeout, this.waitBetweenReads, minBytes, this.limit);
    }

    public ByteChannelReader readNoMoreThan(int maxBytes) {
        return new ByteChannelReader(this.channel, this.timeout, this.waitBetweenReads, this.min, maxBytes);
    }

    public ByteChannelReader readBetween(int minBytes, int maxBytes) {
        return new ByteChannelReader(this.channel, this.timeout, this.waitBetweenReads, minBytes, maxBytes);
    }

    private ByteChannelReader(ReadableByteChannel channel, Optional<Duration> timeout, Optional<Duration> waitBetweenReads, int min, int limit) {
        if (min < 0 || limit < 0 || limit < min) {
            throw new IllegalArgumentException("Illegal arguments: min (" + min + "), limit (" + limit + ")");
        }
        this.channel = Objects.requireNonNull(channel);
        this.timeout = timeout;
        this.waitBetweenReads = waitBetweenReads;
        this.min = min;
        this.limit = limit;
    }

    public int sync(ByteBuffer buf, byte[] syncToken) throws IOException {
        this.ensureSufficientSpace(buf);
        if (syncToken.length == 0) {
            throw new IllegalArgumentException("Empty synchronization token");
        }
        int searchpos = buf.position();
        int origlim = buf.limit();
        boolean found = false;
        int matchpos = -1;
        long t1 = System.currentTimeMillis();
        int readTotal = 0;
        long timeoutMillis = this.getTimeoutMillis();
        long waitBetweenReadsMillis = this.getWaitBetweenReadsMillis();
        do {
            int read;
            if ((read = this.channel.read(buf)) < 0) {
                throw new RuntimeException("Received EOF, total bytes read: " + readTotal + ", expected: " + this.min + ".." + this.limit);
            }
            if (read > 0) {
                if ((readTotal += read) > this.limit) {
                    throw new IllegalStateException("More than " + this.limit + " bytes received: " + readTotal);
                }
                if (!found) {
                    int pos = buf.position();
                    buf.flip();
                    buf.position(searchpos);
                    if (buf.remaining() >= syncToken.length) {
                        if (Buffers.searchPattern(buf, syncToken)) {
                            found = true;
                            matchpos = buf.position();
                        } else {
                            searchpos = pos - syncToken.length + 1;
                        }
                    }
                    buf.limit(origlim);
                    buf.position(pos);
                }
            }
            if (found && this.min > 0 && readTotal >= this.min) break;
            if (waitBetweenReadsMillis <= 0L) continue;
            try {
                Thread.sleep(waitBetweenReadsMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for data", e);
            }
        } while (timeoutMillis == 0L || System.currentTimeMillis() - t1 <= timeoutMillis);
        if (readTotal < this.min) {
            throw new IllegalStateException("Less than " + this.min + " bytes received: " + readTotal);
        }
        if (!found) {
            throw new IllegalStateException("Failed to synchronize: expected " + this.min + ".." + this.limit + ", received " + readTotal);
        }
        buf.position(matchpos);
        return readTotal;
    }

    public int read(ByteBuffer buf) throws IOException {
        this.ensureSufficientSpace(buf);
        long t1 = System.currentTimeMillis();
        int readTotal = 0;
        long timeoutMillis = this.getTimeoutMillis();
        long waitBetweenReadsMillis = this.getWaitBetweenReadsMillis();
        do {
            int read;
            if ((read = this.channel.read(buf)) < 0) {
                throw new RuntimeException("Received EOF, total bytes read: " + readTotal + ", expected: " + this.min + ".." + this.limit);
            }
            if ((readTotal += read) > this.limit) {
                throw new IllegalStateException("More than " + this.limit + " bytes received: " + readTotal);
            }
            if (this.min > 0 && readTotal >= this.min) break;
            if (waitBetweenReadsMillis <= 0L) continue;
            try {
                Thread.sleep(waitBetweenReadsMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for data", e);
            }
        } while (this.min > 0 && timeoutMillis == 0L || System.currentTimeMillis() - t1 <= timeoutMillis);
        if (readTotal < this.min) {
            throw new IllegalStateException("Less than " + this.min + " bytes received: " + readTotal);
        }
        return readTotal;
    }

    private long getTimeoutMillis() {
        return this.timeout.isPresent() ? this.timeout.get().toMillis() : 0L;
    }

    private long getWaitBetweenReadsMillis() {
        return this.waitBetweenReads.isPresent() ? this.waitBetweenReads.get().toMillis() : 0L;
    }

    private void ensureSufficientSpace(ByteBuffer buf) {
        if (buf.remaining() < this.min) {
            throw new IllegalArgumentException("Insufficient space in buffer: " + buf.remaining() + ", required at least: " + this.min);
        }
    }
}

